/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.entities.custom;

import java.util.UUID;
import javax.annotation.Nullable;
import net.jrdemiurge.enigmaticlegacy.Config;
import net.jrdemiurge.enigmaticlegacy.EnigmaticLegacy;
import net.jrdemiurge.enigmaticlegacy.entities.ModEntites;
import net.jrdemiurge.enigmaticlegacy.item.ModItems;
import net.jrdemiurge.enigmaticlegacy.item.custom.SoulCrystal;
import net.jrdemiurge.enigmaticlegacy.item.custom.StorageCrystal;
import net.jrdemiurge.enigmaticlegacy.util.ItemNBTHelper;
import net.jrdemiurge.enigmaticlegacy.util.ModUtils;
import net.jrdemiurge.enigmaticlegacy.util.SoulArchive;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PermanentItemEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(PermanentItemEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int age;
    private int pickupDelay;
    private int health = 5;
    private UUID thrower;
    private UUID owner;
    private Vec3 position;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);

    public PermanentItemEntity(EntityType<PermanentItemEntity> type, Level world) {
        super(type, world);
    }

    public PermanentItemEntity(Level world, double x, double y, double z) {
        this(ModEntites.PERMANENT_ITEM_ENTITY.get(), world);
        y = y <= (double)world.getMinBuildHeight() ? (double)(world.getMinBuildHeight() + 8) : y;
        this.setPos(x, y, z);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.setInvulnerable(true);
        this.setNoGravity(true);
        this.position = new Vec3(x, y, z);
    }

    public PermanentItemEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setItem(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private PermanentItemEntity(PermanentItemEntity p_i231561_1_) {
        super(p_i231561_1_.getType(), p_i231561_1_.level());
        this.setItem(p_i231561_1_.getItem().copy());
        this.copyPosition(p_i231561_1_);
        this.age = p_i231561_1_.age;
        this.hoverStart = p_i231561_1_.hoverStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PermanentItemEntity copy() {
        return new PermanentItemEntity(this);
    }

    public boolean dampensVibrations() {
        return this.getItem().is(ItemTags.DAMPENS_VIBRATIONS);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    public void tick() {
        if (this.getItem().isEmpty()) {
            this.discard();
        } else {
            ItemStack item;
            double d0;
            if (!this.level().isClientSide && this.position != null && !this.position().equals((Object)this.position)) {
                this.teleportTo(this.position.x, this.position.y, this.position.z);
            }
            super.tick();
            if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
                --this.pickupDelay;
            }
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            Vec3 vec3d = this.getDeltaMovement();
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
            }
            if (this.level().isClientSide) {
                this.noPhysics = false;
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0);
            }
            ++this.age;
            if (!this.level().isClientSide && (d0 = this.getDeltaMovement().subtract(vec3d).lengthSqr()) > 0.01) {
                this.hasImpulse = true;
            }
            if ((item = this.getItem()).isEmpty()) {
                this.discard();
            }
            this.setPortalCooldown();
        }
    }

    public int getDimensionChangingDelay() {
        return Short.MAX_VALUE;
    }

    public Entity changeDimension(DimensionTransition transition) {
        return null;
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide || !this.isAlive()) {
            return false;
        }
        if (ModUtils.isAbsolute(source)) {
            EnigmaticLegacy.LOGGER.warn("[WARN] Attacked permanent item entity with absolute DamageSource: " + String.valueOf(source));
            this.kill();
            return true;
        }
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED || reason == Entity.RemovalReason.KILLED) {
            EnigmaticLegacy.LOGGER.warn("[WARN] Removing Permanent Item Entity: " + String.valueOf((Object)this));
            if (!this.level().isClientSide) {
                SoulArchive.getInstance().removeItem(this);
            }
        }
        super.remove(reason);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("Health", (short)this.health);
        compound.putShort("Age", (short)this.age);
        compound.putShort("PickupDelay", (short)this.pickupDelay);
        if (this.getThrowerId() != null) {
            compound.putUUID("Thrower", this.getThrowerId());
        }
        if (this.getOwnerId() != null) {
            compound.putUUID("Owner", this.getOwnerId());
        }
        if (!this.getItem().isEmpty()) {
            compound.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        if (this.position != null) {
            compound.putDouble("BoundX", this.position.x);
            compound.putDouble("BoundY", this.position.y);
            compound.putDouble("BoundZ", this.position.z);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.health = compound.getShort("Health");
        this.age = compound.getShort("Age");
        if (compound.contains("PickupDelay")) {
            this.pickupDelay = compound.getShort("PickupDelay");
        }
        if (compound.contains("Owner")) {
            this.owner = compound.getUUID("Owner");
        }
        if (compound.contains("Thrower")) {
            this.thrower = compound.getUUID("Thrower");
        }
        if (compound.contains("BoundX") && compound.contains("BoundY") && compound.contains("BoundZ")) {
            double x = compound.getDouble("BoundX");
            double y = compound.getDouble("BoundY");
            double z = compound.getDouble("BoundZ");
            this.position = new Vec3(x, y, z);
        }
        CompoundTag compoundnbt = compound.getCompound("Item");
        this.setItem(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compoundnbt));
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide) {
            if (this.pickupDelay > 0) {
                return;
            }
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            ItemStack copy = itemstack.copy();
            boolean isPlayerOwner = player.getUUID().equals(this.getOwnerId());
            boolean allowPickUp = false;
            if (item instanceof StorageCrystal && (isPlayerOwner || !Config.OWNER_ONLY_VESSEL.isTrue())) {
                allowPickUp = true;
            } else if (item instanceof SoulCrystal && isPlayerOwner) {
                allowPickUp = true;
            }
            if (allowPickUp) {
                if (item instanceof StorageCrystal) {
                    ItemStack embeddedSoul;
                    CompoundTag crystalNBT = ItemNBTHelper.getNBT(itemstack);
                    ItemStack itemStack = embeddedSoul = crystalNBT.contains("embeddedSoul") ? ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)crystalNBT.getCompound("embeddedSoul")) : null;
                    if (!isPlayerOwner && embeddedSoul != null) {
                        return;
                    }
                    StorageCrystal.retrieveDropsFromCrystal(itemstack, player, embeddedSoul);
                    SoulArchive.getInstance().removeItem(this);
                } else if (item instanceof SoulCrystal) {
                    if (!SoulCrystal.retrieveSoulFromCrystal(player, itemstack)) {
                        return;
                    }
                    SoulArchive.getInstance().removeItem(this);
                }
                player.take((Entity)this, i);
                EnigmaticLegacy.LOGGER.info("Player " + player.getGameProfile().getName() + " picking up: " + String.valueOf((Object)this));
                this.discard();
                itemstack.setCount(0);
            } else if (this.pickupDelay == 0 && (this.owner == null || this.owner.equals(player.getUUID())) && (i <= 0 || player.getInventory().add(itemstack))) {
                copy.setCount(copy.getCount() - this.getItem().getCount());
                if (itemstack.isEmpty()) {
                    player.take((Entity)this, i);
                    EnigmaticLegacy.LOGGER.info("Player " + player.getGameProfile().getName() + " picking up: " + String.valueOf((Object)this));
                    this.discard();
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
            }
        }
    }

    public boolean containsSoul() {
        if (this.getItem().is(ModItems.SOUL_CRYSTAL)) {
            return true;
        }
        if (this.getItem().is(ModItems.STORAGE_CRYSTAL)) {
            return ItemNBTHelper.getNBT(this.getItem()).contains("embeddedSoul");
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getItemHover(float partialTicks) {
        return ((float)this.getAge() + partialTicks) / 20.0f + this.hoverStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public Component getName() {
        Component itextcomponent = this.getCustomName();
        return itextcomponent != null ? itextcomponent : Component.translatable((String)this.getItem().getDescriptionId());
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isCurrentlyGlowing() {
        return true;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(ITEM, (Object)stack);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.owner = ownerId;
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrowerId(@Nullable UUID throwerId) {
        this.thrower = throwerId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAge() {
        return this.age;
    }

    public void setDefaultPickupDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickupDelay() {
        this.pickupDelay = 0;
    }

    public void setInfinitePickupDelay() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickupDelay(int ticks) {
        this.pickupDelay = ticks;
    }

    public boolean cannotPickup() {
        return this.pickupDelay > 0;
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
    }
}

