/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticlegacy.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.jrdemiurge.enigmaticlegacy.entities.custom.PermanentItemEntity;
import net.jrdemiurge.enigmaticlegacy.item.custom.IPermanentCrystal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PermanentItemRenderer
extends EntityRenderer<PermanentItemEntity> {
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();

    public PermanentItemRenderer(EntityRendererProvider.Context renderManagerIn, ItemRenderer itemRendererIn) {
        super(renderManagerIn);
        this.itemRenderer = itemRendererIn;
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.getCount() > 48) {
            i = 5;
        } else if (stack.getCount() > 32) {
            i = 4;
        } else if (stack.getCount() > 16) {
            i = 3;
        } else if (stack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public void render(PermanentItemEntity entityIn, float entityYaw, float partialTicks, PoseStack PoseStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!Minecraft.getInstance().player.isAlive() && Math.sqrt(entityIn.distanceToSqr(Minecraft.getInstance().player.getX(), Minecraft.getInstance().player.getEyeY(), Minecraft.getInstance().player.getZ())) <= 1.0) {
            return;
        }
        PoseStackIn.pushPose();
        ItemStack itemstack = entityIn.getItem();
        if (itemstack.getItem() instanceof IPermanentCrystal) {
            PoseStackIn.scale(1.25f, 1.25f, 1.25f);
            PoseStackIn.translate(0.0, -0.1125, 0.0);
        }
        int i = itemstack.isEmpty() ? 187 : Item.getId((Item)itemstack.getItem()) + itemstack.getDamageValue();
        this.random.setSeed(i);
        BakedModel ibakedmodel = this.itemRenderer.getModel(itemstack, entityIn.level(), null, entityIn.getId());
        boolean flag = ibakedmodel.isGui3d();
        int j = this.getModelCount(itemstack);
        float f = 0.25f;
        float f1 = Mth.sin((float)(((float)entityIn.getAge() + partialTicks) / 10.0f + entityIn.hoverStart)) * 0.1f + 0.1f;
        float f2 = this.shouldBob() ? ibakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y() : 0.0f;
        PoseStackIn.translate(0.0, (double)(f1 + 0.25f * f2), 0.0);
        float f3 = entityIn.getItemHover(partialTicks);
        PoseStackIn.mulPose(Axis.YP.rotation(f3));
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            PoseStackIn.translate(f7, f8, f9);
        }
        for (int k = 0; k < j; ++k) {
            PoseStackIn.pushPose();
            if (k > 0) {
                if (flag) {
                    float f11 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f13 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    PoseStackIn.translate(this.shouldSpreadItems() ? f11 : 0.0f, this.shouldSpreadItems() ? f13 : 0.0f, this.shouldSpreadItems() ? f10 : 0.0f);
                } else {
                    float f12 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f14 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    PoseStackIn.translate(this.shouldSpreadItems() ? (double)f12 : 0.0, this.shouldSpreadItems() ? (double)f14 : 0.0, 0.0);
                }
            }
            this.itemRenderer.render(itemstack, ItemDisplayContext.GROUND, false, PoseStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, ibakedmodel);
            PoseStackIn.popPose();
            if (flag) continue;
            PoseStackIn.translate(0.0, 0.0, 0.09375);
        }
        PoseStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, PoseStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(PermanentItemEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }
}

