/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentAttributeModifier;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class StrengthAugment
extends Augment {
    private static final ResourceLocation ATTRIBUTE_ID = MysticalAgriculture.resource("strength_augment");
    private final List<AugmentAttributeModifier> attributes;

    public StrengthAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.SWORD), StrengthAugment.getColor(16776592, tier), StrengthAugment.getColor(13405735, tier));
        this.attributes = List.of(new AugmentAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, new AttributeModifier(ATTRIBUTE_ID, (double)(5 * amplifier), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    @Override
    public List<AugmentAttributeModifier> getAttributeModifiers() {
        return this.attributes;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

