/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.soul;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MobSoulType {
    private final ResourceLocation id;
    private final Set<ResourceLocation> entityIds;
    private double soulRequirement;
    private int color;
    private String entityDisplayNameKey = null;
    private Component entityDisplayName = null;
    private boolean enabled;

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.color = FastColor.ARGB32.color((int)204, (int)color);
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = FastColor.ARGB32.color((int)204, (int)color);
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, Set<ResourceLocation> entityIds, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = entityIds;
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = FastColor.ARGB32.color((int)204, (int)color);
        this.enabled = true;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.getId().getPath();
    }

    public String getModId() {
        return this.getId().getNamespace();
    }

    public Set<ResourceLocation> getEntityIds() {
        return this.entityIds;
    }

    public double getSoulRequirement() {
        return this.soulRequirement;
    }

    public MobSoulType setSoulRequirement(double soulRequirement) {
        this.soulRequirement = soulRequirement;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public MobSoulType setColor(int color) {
        this.color = FastColor.ARGB32.color((int)204, (int)color);
        return this;
    }

    public boolean isEntityApplicable(LivingEntity entity) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return this.entityIds.contains(id);
    }

    public Component getEntityDisplayName() {
        if (this.entityDisplayName == null) {
            if (this.entityDisplayNameKey != null) {
                this.entityDisplayName = Component.translatable((String)String.format("mobSoulType.%s.%s", this.getModId(), this.entityDisplayNameKey));
            } else {
                Optional entity;
                ResourceLocation entityId = this.entityIds.stream().findFirst().orElse(null);
                if (entityId != null && (entity = BuiltInRegistries.ENTITY_TYPE.getOptional(entityId)).isPresent()) {
                    this.entityDisplayName = ((EntityType)entity.get()).getDescription();
                    return this.entityDisplayName;
                }
                this.entityDisplayName = Component.translatable((String)"tooltip.mysticalagriculture.invalid_entity");
            }
        }
        return this.entityDisplayName;
    }

    public MobSoulType setEntityDisplayName(Component name) {
        this.entityDisplayName = name;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MobSoulType setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

