/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization.item;

import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.fertilization.item.CompressedBoneMealItem;
import net.blay09.mods.fertilization.item.ExtremelyCompressedBoneMealItem;
import net.blay09.mods.fertilization.item.FloristsBoneMealItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ModItems {
    public static CompressedBoneMealItem compressedBoneMeal;
    public static ExtremelyCompressedBoneMealItem extremelyCompressedBoneMeal;
    public static FloristsBoneMealItem floristsBoneMeal;

    public static void initialize(BalmItems items) {
        items.registerItem(() -> {
            compressedBoneMeal = new CompressedBoneMealItem(items.itemProperties());
            return compressedBoneMeal;
        }, ModItems.id("compressed_bonemeal"));
        items.registerItem(() -> {
            extremelyCompressedBoneMeal = new ExtremelyCompressedBoneMealItem(items.itemProperties());
            return extremelyCompressedBoneMeal;
        }, ModItems.id("extremely_compressed_bonemeal"));
        items.registerItem(() -> {
            floristsBoneMeal = new FloristsBoneMealItem(items.itemProperties());
            return floristsBoneMeal;
        }, ModItems.id("florists_bonemeal"));
        items.registerCreativeModeTab(() -> new ItemStack((ItemLike)compressedBoneMeal), ModItems.id("fertilization"));
    }

    public static void registerBoneMealDispenseBehaviour(final CompressedBoneMealItem boneMealItem) {
        DispenserBlock.registerBehavior((ItemLike)boneMealItem, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack itemStack) {
                this.setSuccess(true);
                ServerLevel level = source.level();
                BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                BlockState state = level.getBlockState(pos);
                if (boneMealItem.applyBoneMeal((Level)level, pos, state, itemStack, null) != InteractionResult.SUCCESS) {
                    this.setSuccess(false);
                } else if (!level.isClientSide) {
                    level.levelEvent(2005, pos, 0);
                }
                if (this.isSuccess()) {
                    itemStack.shrink(1);
                }
                return itemStack;
            }
        });
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"fertilization", (String)name);
    }
}

