/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization.item;

import java.util.List;
import net.blay09.mods.fertilization.BoneMealHelper;
import net.blay09.mods.fertilization.FertilizationConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class FloristsBoneMealItem
extends Item {
    public FloristsBoneMealItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack itemStack) {
                this.setSuccess(true);
                ServerLevel level = source.level();
                BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                BlockState state = level.getBlockState(pos);
                if (state.isAir()) {
                    pos = pos.below();
                    state = level.getBlockState(pos);
                }
                if (!FloristsBoneMealItem.this.applyBoneMeal((Level)level, pos, state, itemStack, null)) {
                    this.setSuccess(false);
                }
                return itemStack;
            }
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.getHand();
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof DoublePlantBlock && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
            state = level.getBlockState(pos.below());
        }
        if (this.applyBoneMeal(level, pos, state, player.getItemInHand(hand), player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean applyBoneMeal(Level level, BlockPos pos, BlockState state, ItemStack itemStack, @Nullable Player player) {
        if (FertilizationConfig.getActive().isFlowerBlock(state.getBlock())) {
            if (!level.isClientSide) {
                List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    ItemEntity entityItem = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), drop);
                    level.addFreshEntity((Entity)entityItem);
                }
                if (player == null || !player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                level.levelEvent(2005, pos, 0);
            }
            return true;
        }
        if (BoneMealHelper.isGrassBlock(state)) {
            if (!level.isClientSide) {
                RandomSource random = level.random;
                int tries = FertilizationConfig.getActive().floristsBoneMealMaxFlowers;
                int range = FertilizationConfig.getActive().floristsBoneMealMaxRange;
                boolean spawnedAnyFlower = false;
                for (int i = 0; i < tries; ++i) {
                    BlockPos flowerPos = new BlockPos(pos.getX() + random.nextInt(range * 2) - range, pos.getY() + 1, pos.getZ() + random.nextInt(range * 2) - range);
                    if (!level.isEmptyBlock(flowerPos) || !BoneMealHelper.isGrassBlock(level.getBlockState(flowerPos.below()))) continue;
                    this.plantFlower((ServerLevel)level, flowerPos, random);
                    spawnedAnyFlower = true;
                }
                if (spawnedAnyFlower) {
                    level.levelEvent(2005, pos, 0);
                } else {
                    level.levelEvent(2000, pos.above(), 4);
                }
            }
            if (player == null || !player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    private void plantFlower(ServerLevel level, BlockPos pos, RandomSource rand) {
        List list = ((Biome)level.getBiome(pos).value()).getGenerationSettings().getFlowerFeatures();
        if (list.isEmpty()) {
            return;
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)list.get(0);
        FeatureConfiguration config = configuredFeature.config();
        PlacedFeature placedFeature = (PlacedFeature)((RandomPatchConfiguration)config).feature().value();
        placedFeature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), rand, pos);
    }
}

