/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.utility;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static VoxelShape[] getRotatedShapes(VoxelShape shape) {
        return new VoxelShape[]{VoxelShapeUtil.rotateVoxelShape(shape, Direction.SOUTH), VoxelShapeUtil.rotateVoxelShape(shape, Direction.WEST), shape, VoxelShapeUtil.rotateVoxelShape(shape, Direction.EAST)};
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction direction) {
        return VoxelShapeUtil.rotateShape(shape, Direction.NORTH, direction);
    }

    public static VoxelShape[] rotateVoxelShapes(VoxelShape[] shapes, Direction direction) {
        return VoxelShapeUtil.rotateVoxelShapes(shapes, Direction.NORTH, direction);
    }

    public static VoxelShape[] rotateVoxelShapes(VoxelShape[] shapes, Direction from, Direction to) {
        VoxelShape[] rotatedShapes = new VoxelShape[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            rotatedShapes[i] = VoxelShapeUtil.rotateShape(shapes[i], from, to);
        }
        return rotatedShapes;
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction from, Direction to) {
        if (from == to) {
            return shape;
        }
        boolean[] isSquare = new boolean[]{true};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            if (minX != minZ || maxX != maxZ) {
                isSquare[0] = false;
            }
        });
        if (isSquare[0]) {
            return shape;
        }
        int rotationDegrees = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4 * 90;
        return VoxelShapeUtil.rotateShape(shape, rotationDegrees);
    }

    private static VoxelShape rotateShape(VoxelShape shape, int degrees) {
        VoxelShape[] buffer = new VoxelShape[]{Shapes.empty()};
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape rotated = switch (degrees) {
                case 90 -> Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                case 180 -> Shapes.box((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                case 270 -> Shapes.box((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                default -> shape;
            };
            buffer[0] = Shapes.joinUnoptimized((VoxelShape)buffer[0], (VoxelShape)rotated, (BooleanOp)BooleanOp.OR);
        });
        return buffer[0];
    }
}

