/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.item.FrightsDelightConsumableItem;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class FrightsDelightDrinkableItem
extends FrightsDelightConsumableItem {
    private final SoundEvent consumeSound;

    public FrightsDelightDrinkableItem(Item.Properties properties) {
        super(properties);
        this.consumeSound = null;
    }

    public FrightsDelightDrinkableItem(Item.Properties settings, boolean hasFoodEffectTooltip) {
        super(settings, hasFoodEffectTooltip);
        this.consumeSound = null;
    }

    public FrightsDelightDrinkableItem(Item.Properties settings, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(settings, hasFoodEffectTooltip, hasCustomTooltip);
        this.consumeSound = null;
    }

    public FrightsDelightDrinkableItem(Item.Properties settings, SoundEvent consumeSound, boolean hasFoodEffectTooltip) {
        super(settings, hasFoodEffectTooltip);
        this.consumeSound = consumeSound;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        FoodProperties foodData = (FoodProperties)heldStack.get(DataComponents.FOOD);
        if (foodData != null) {
            if (player.canEat(foodData.canAlwaysEat())) {
                player.startUsingItem(hand);
                if (Configuration.punchConsumeSound() && this.consumeSound != null && new Random().nextInt(Configuration.punchConsumeChance()) == 0) {
                    BlockPos pos = new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ());
                    level.playSound((Player)null, pos, this.consumeSound, SoundSource.HOSTILE, 0.5f, 0.8f + level.random.nextFloat() * 0.4f);
                }
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }
}

