/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.block.GlassCupBlock;
import com.chefmooon.frightsdelight.common.item.FrightsDelightConsumableItemNameBlockItem;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FrightsDelightDrinkableBlockItem
extends FrightsDelightConsumableItemNameBlockItem {
    protected final boolean hasCustomTooltip;
    private final SoundEvent consumeSound;

    public FrightsDelightDrinkableBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        this(block, properties, null, hasFoodEffectTooltip, hasCustomTooltip);
    }

    public FrightsDelightDrinkableBlockItem(Block block, Item.Properties properties, SoundEvent consumeSound, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(block, properties, hasFoodEffectTooltip);
        this.consumeSound = consumeSound;
        this.hasCustomTooltip = hasCustomTooltip;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        FoodProperties foodData = (FoodProperties)heldStack.get(DataComponents.FOOD);
        if (foodData != null) {
            if (player.canEat(foodData.canAlwaysEat())) {
                player.startUsingItem(hand);
                if (Configuration.punchConsumeSound() && this.consumeSound != null && new Random().nextInt(Configuration.punchConsumeChance()) == 0) {
                    BlockPos pos = new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ());
                    level.playSound((Player)null, pos, this.consumeSound, SoundSource.HOSTILE, 0.5f, 0.8f + level.random.nextFloat() * 0.4f);
                }
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        if (stack.get(DataComponents.FOOD) != null) {
            super.finishUsingItem(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        if (stack.isEmpty()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).getAbilities().instabuild && !player.getInventory().add(containerStack)) {
                player.drop(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.isShiftKeyDown()) return InteractionResult.FAIL;
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        Level level = blockPlaceContext.getLevel();
        ItemStack itemStack = blockPlaceContext.getItemInHand();
        BlockState blockState2 = level.getBlockState(blockPos);
        Block block = blockState2.getBlock();
        if (!(block instanceof GlassCupBlock)) return super.place(context);
        GlassCupBlock glassCupBlock = (GlassCupBlock)block;
        if (!itemStack.is(glassCupBlock.servingItem.get())) return super.place(context);
        glassCupBlock.addServingFromHand(level, blockPos, blockState2, player, player.getUsedItemHand());
        return InteractionResult.FAIL;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (Configuration.foodEffectTooltip()) {
            if (this.hasCustomTooltip) {
                tooltip.add((Component)TextUtils.getTranslatable("tooltip.glass_cup", new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (this.hasFoodEffectTooltip) {
                if (Configuration.foodEffectChanceTooltip()) {
                    TextUtils.addFoodEffectTooltipWithDetail(stack, tooltip::add, 1.0f, context.tickRate());
                } else {
                    TextUtils.addFoodEffectTooltip(stack, tooltip::add, 1.0f, context.tickRate());
                }
            }
        }
    }
}

