/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.effect;

import com.chefmooon.frightsdelight.common.registry.FrightsDelightEffects;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.Random;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class HysteriaEffect
extends MobEffect {
    public HysteriaEffect() {
        super(MobEffectCategory.HARMFUL, 5981496);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        int soundChance;
        Random random;
        Player player;
        if (livingEntity.hasEffect(FrightsDelightEffects.FORTIFIED_MIND)) {
            return false;
        }
        if (!livingEntity.getCommandSenderWorld().isClientSide() && livingEntity instanceof Player && !(player = (Player)livingEntity).hasEffect(FrightsDelightEffects.FORTIFIED_MIND) && (random = new Random()).nextInt(soundChance = 200 - player.getFoodData().getFoodLevel() * 5) == 0) {
            int distance = random.nextInt(3);
            Vec3 pos = player.position();
            if (distance == 0) {
                double range = 4.0;
                double dx = pos.x() + (random.nextDouble() * range - range / 2.0);
                double dy = pos.y() + 1.0;
                double dz = pos.z() + (random.nextDouble() * range - range / 2.0);
                player.playNotifySound(FrightsDelightSounds.EFFECT_HYSTERIA_CLOSE.get(), SoundSource.HOSTILE, 0.2f, 0.6f);
            } else if (distance == 1) {
                double range = 8.0;
                double dx = pos.x() + (random.nextDouble() * range - range / 2.0);
                double dy = pos.y() + 1.0;
                double dz = pos.z() + (random.nextDouble() * range - range / 2.0);
                player.playNotifySound(FrightsDelightSounds.EFFECT_HYSTERIA_MID.get(), SoundSource.HOSTILE, 0.2f, 0.6f);
            } else {
                double range = 16.0;
                double dx = pos.x() + (random.nextDouble() * range - range / 2.0);
                double dy = pos.y() + 1.0;
                double dz = pos.z() + (random.nextDouble() * range - range / 2.0);
                player.playNotifySound(FrightsDelightSounds.EFFECT_HYSTERIA_FAR.get(), SoundSource.HOSTILE, 0.2f, 0.6f);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

