/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.neoforge;

import com.chefmooon.frightsdelight.common.block.AbstractCandyBasketBlock;
import com.chefmooon.frightsdelight.common.block.entity.CandyBasketBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class AbstractCandyBasketBlockImpl
extends AbstractCandyBasketBlock {
    public AbstractCandyBasketBlockImpl(BlockBehaviour.Properties properties, CandyBasketType type) {
        super(properties, type);
    }

    @EventBusSubscriber(modid="frightsdelight", bus=EventBusSubscriber.Bus.GAME)
    public static class ShuffleEvent {
        @SubscribeEvent
        public static InteractionResult onSneak(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.getMainHandItem();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (player.isSecondaryUseActive() && blockEntity instanceof CandyBasketBlockEntity) {
                CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
                if (!candyBasketBlockEntity.isEmpty()) {
                    boolean shuffled = AbstractCandyBasketBlock.shuffleInventory(level, pos);
                    if (shuffled) {
                        Supplier<SoundEvent> shuffleSound;
                        Block block = level.getBlockState(pos).getBlock();
                        if (block instanceof AbstractCandyBasketBlockImpl) {
                            AbstractCandyBasketBlockImpl candyBasketBlock = (AbstractCandyBasketBlockImpl)block;
                            v0 = candyBasketBlock.getCandyBasketType().getShuffleSound();
                        } else {
                            v0 = shuffleSound = null;
                        }
                        if (shuffleSound != null) {
                            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, shuffleSound.get(), SoundSource.PLAYERS, Math.min(0.3f + 0.04f * (float)candyBasketBlockEntity.getFilledSlotsCount(), 1.0f), 1.0f, false);
                        }
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.get().trigger(serverPlayer);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, FrightsDelightSounds.BLOCK_CANDY_BASKET_EMPTY.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
                }
            }
            return InteractionResult.PASS;
        }
    }
}

