/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightDamageTypes;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.tag.FrightsDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WitherBerryBushBlock
extends FrightsDelightBushBlock {
    public static final int GROW_RANGE = 1;
    public static final TagKey<Block> GROW_CONDITION_BLOCK = FrightsDelightTags.WITHER_BERRY_BUSH_GROW_CONDITIION;

    public WitherBerryBushBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
        return (BlockState)state.setValue((Property)GROW_CONDITION, (Comparable)Boolean.valueOf(WitherBerryBushBlock.hasGrowthCondition((LevelAccessor)level, pos, 1, GROW_CONDITION_BLOCK)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.WITHER_BERRY));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        this.updateCondition(state, (LevelAccessor)level, pos);
        if (((Boolean)state.getValue((Property)GROW_CONDITION)).booleanValue() && i < 3 && random.nextInt(5) == 0 && WitherBerryBushBlock.hasGrowBrightness(level.getRawBrightness(pos.above(), 0))) {
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)GROW_CONDITION)).booleanValue() && WitherBerryBushBlock.hasGrowBrightness(level.getRawBrightness(pos.above(), 0))) {
            VoxelShape voxelShape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
            Vec3 vec3 = voxelShape.bounds().getCenter();
            double d = (double)pos.getX() + vec3.x;
            double e = (double)pos.getZ() + vec3.z;
            for (int i = 0; i < 3; ++i) {
                if (!random.nextBoolean()) continue;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + random.nextDouble() / 5.0, (double)pos.getY() + (0.5 - random.nextDouble()), e + random.nextDouble() / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean bl;
        if (!level.isClientSide()) {
            this.updateCondition(state, (LevelAccessor)level, pos);
        }
        InteractionHand hand = player.getUsedItemHand();
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            WitherBerryBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.WITHER_BERRY), j + (bl ? 1 : 0)));
            level.playSound((Player)null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateCondition(state, (LevelAccessor)level, pos);
        super.performBonemeal(level, random, pos, state);
    }

    @Override
    public DamageSource getDamageSource(Level level) {
        return FrightsDelightDamageTypes.getSimpleDamageSource(level, FrightsDelightDamageTypes.WITHER_BERRY_BUSH);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!level.isClientSide()) {
            this.updateCondition(state, level, pos);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void updateCondition(BlockState state, LevelAccessor level, BlockPos pos) {
        this.updateGrowthCondition(state, level, pos, 1, GROW_CONDITION_BLOCK, (Boolean)state.getValue((Property)GROW_CONDITION));
    }

    public static boolean hasGrowBrightness(int lightLevel) {
        return lightLevel <= 7;
    }
}

