/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.block.WitherBerryBushBlock;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlocks;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightDamageTypes;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.tag.FrightsDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SoulBerryBushBlock
extends FrightsDelightBushBlock {
    public static final int GROW_RANGE = 5;
    public static final TagKey<Block> GROW_CONDITION_BLOCK = FrightsDelightTags.SOUL_BERRY_BUSH_GROW_CONDITIION;
    public static final BooleanProperty TRANSFORM_CONDITION = BooleanProperty.create((String)"transform_condition");

    public SoulBerryBushBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)TRANSFORM_CONDITION, (Comparable)Boolean.FALSE);
        return (BlockState)state.setValue((Property)GROW_CONDITION, (Comparable)Boolean.valueOf(SoulBerryBushBlock.hasGrowthCondition((LevelAccessor)level, pos, 5, GROW_CONDITION_BLOCK)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.SOUL_BERRY));
    }

    @Override
    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState;
        int i = (Integer)state.getValue((Property)AGE);
        this.updateConditions(state, (LevelAccessor)level, pos);
        if (((Boolean)state.getValue((Property)GROW_CONDITION)).booleanValue() && i < 3 && random.nextInt(5) == 0 && SoulBerryBushBlock.hasGrowBrightness(level.getRawBrightness(pos.above(), 0))) {
            blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
        if (i == 3 && SoulBerryBushBlock.hasTransformBrightness(level.getRawBrightness(pos.above(), 0)) && SoulBerryBushBlock.hasTransformCondition((LevelAccessor)level, pos)) {
            blockState = (BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(FrightsDelightBlocks.WITHER_BERRY_BUSH)).defaultBlockState().setValue((Property)WitherBerryBushBlock.GROW_CONDITION, (Comparable)Boolean.TRUE)).setValue((Property)WitherBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
            level.playSound((Player)null, pos, SoundEvents.SOUL_SAND_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean bl;
        if (!level.isClientSide()) {
            this.updateConditions(state, (LevelAccessor)level, pos);
        }
        InteractionHand hand = player.getUsedItemHand();
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            SoulBerryBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.SOUL_BERRY), j + (bl ? 1 : 0)));
            level.playSound((Player)null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateConditions(state, (LevelAccessor)level, pos);
        super.performBonemeal(level, random, pos, state);
    }

    @Override
    public DamageSource getDamageSource(Level level) {
        return FrightsDelightDamageTypes.getSimpleDamageSource(level, FrightsDelightDamageTypes.SOUL_BERRY_BUSH);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!level.isClientSide()) {
            this.updateConditions(state, level, pos);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TRANSFORM_CONDITION});
    }

    public static boolean hasTransformCondition(LevelAccessor level, BlockPos pos) {
        int TRANSFORM_GROW_RANGE = 1;
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)BlockPos.of((long)BlockPos.offset((long)pos.asLong(), (int)(-TRANSFORM_GROW_RANGE), (int)-1, (int)(-TRANSFORM_GROW_RANGE))), (BlockPos)BlockPos.of((long)BlockPos.offset((long)pos.asLong(), (int)TRANSFORM_GROW_RANGE, (int)1, (int)TRANSFORM_GROW_RANGE)))) {
            if (!level.getBlockState(blockPos).is(WitherBerryBushBlock.GROW_CONDITION_BLOCK)) continue;
            return true;
        }
        return false;
    }

    public void updateTransformCondition(BlockState state, LevelAccessor level, BlockPos pos, boolean oldCondition) {
        boolean newCondition = SoulBerryBushBlock.hasTransformCondition(level, pos);
        if (newCondition != oldCondition) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRANSFORM_CONDITION, (Comparable)Boolean.valueOf(newCondition)), 2);
        }
    }

    public void updateConditions(BlockState state, LevelAccessor level, BlockPos pos) {
        this.updateGrowthCondition(state, level, pos, 5, GROW_CONDITION_BLOCK, (Boolean)state.getValue((Property)GROW_CONDITION));
        this.updateTransformCondition(state, level, pos, (Boolean)state.getValue((Property)TRANSFORM_CONDITION));
    }

    public static boolean hasGrowBrightness(int lightLevel) {
        return lightLevel >= 9;
    }

    public static boolean hasTransformBrightness(int lightLevel) {
        return lightLevel <= 7;
    }

    public BooleanProperty getTransformConditionProperty() {
        return TRANSFORM_CONDITION;
    }
}

