/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.AbstractMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.RingCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RingCandyMoldBlock
extends AbstractMoldBlock {
    public RingCandyMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RingCandyMoldBlockEntity) {
            ItemStack mainHandItem = player.getItemInHand(hand);
            Syrups syrup = (Syrups)((Object)state.getValue((Property)SYRUP_TYPE));
            if (!((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
                if (syrup == Syrups.EMPTY && ITEM_TO_SYRUP.containsKey(BuiltInRegistries.ITEM.getKey((Object)mainHandItem.getItem()))) {
                    Syrups newSyrup = (Syrups)((Object)ITEM_TO_SYRUP.get(BuiltInRegistries.ITEM.getKey((Object)mainHandItem.getItem())));
                    level.setBlock(pos, (BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)newSyrup)), 3);
                    level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_FILL.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                    if (!player.getAbilities().instabuild) {
                        mainHandItem.shrink(1);
                        ItemStack dropStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                        if (!player.addItem(dropStack)) {
                            player.drop(dropStack, false);
                        }
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                if (mainHandItem.is(Items.GLASS_BOTTLE) && syrup != Syrups.EMPTY && !((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
                    ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getSyrupBottleItem()));
                    if (!player.getAbilities().instabuild) {
                        mainHandItem.shrink(1);
                        if (!player.addItem(dropStack)) {
                            player.drop(dropStack, false);
                        }
                    }
                    level.setBlock(pos, (BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY)), 3);
                    level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_DRAIN.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (syrup != Syrups.EMPTY) {
                ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getRingCandyItem()), 4);
                if (!player.getAbilities().instabuild && !player.addItem(dropStack)) {
                    player.drop(dropStack, false);
                }
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).setValue((Property)HARDENED, (Comparable)Boolean.valueOf(false)), 3);
                level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        BlockEntityType blockEntityType = Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.RING_CANDY_MOLD));
        return RingCandyMoldBlock.createTickerHelper(blockEntity, (BlockEntityType)blockEntityType, BaseCandyMoldBlockEntity::hardenTick);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.RING_CANDY_MOLD)).create(pos, state);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int signal = 0;
        if (state.getValue((Property)SYRUP_TYPE) != Syrups.EMPTY) {
            signal += 6;
        }
        if (((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
            signal += 4;
        }
        return signal;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (blockEntity instanceof RingCandyMoldBlockEntity && ((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
            NonNullList contents = NonNullList.create();
            Syrups syrup = (Syrups)((Object)state.getValue((Property)SYRUP_TYPE));
            if (syrup != Syrups.EMPTY) {
                contents.add((Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getRingCandyItem()), 4));
            }
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)contents);
        }
    }
}

