/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.entity.CandyBasketBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCandyBasketBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<AbstractCandyBasketBlock> CODEC = AbstractCandyBasketBlock.simpleCodec(AbstractCandyBasketBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private CandyBasketType candyBasketType = CandyBasketType.NONE;

    public AbstractCandyBasketBlock(BlockBehaviour.Properties properties, CandyBasketType type) {
        this(properties);
        this.candyBasketType = type;
    }

    public AbstractCandyBasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.CANDY_BASKET)).create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CandyBasketBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack mainHandItem = player.getItemInHand(hand);
        if (!player.isSecondaryUseActive()) {
            if (!mainHandItem.isEmpty() || player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !player.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                if (!mainHandItem.has(DataComponents.FOOD)) {
                    return ItemInteractionResult.FAIL;
                }
                boolean addItem = AbstractCandyBasketBlock.addItem(mainHandItem, level, pos);
                if (addItem) {
                    Supplier<SoundEvent> addSound;
                    if (!player.getAbilities().instabuild) {
                        mainHandItem.split(1);
                    }
                    if ((addSound = this.candyBasketType.getAddSound()) != null) {
                        level.playLocalSound(pos, addSound.get(), SoundSource.BLOCKS, 0.4f, 1.0f, false);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                ItemStack removeItem = AbstractCandyBasketBlock.removeItem(level, pos);
                if (!removeItem.isEmpty()) {
                    Supplier<SoundEvent> removeSound;
                    if (!player.getAbilities().instabuild && player.getInventory().add(removeItem)) {
                        player.drop(removeItem, false);
                    }
                    if ((removeSound = this.candyBasketType.getRemoveSound()) != null) {
                        level.playLocalSound(pos, removeSound.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_BASKET_EMPTY.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public CandyBasketType getCandyBasketType() {
        return this.candyBasketType;
    }

    public static boolean addItem(ItemStack itemStack, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.addItem(itemStack);
        }
        return false;
    }

    public static ItemStack removeItem(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.removeItem();
        }
        return ItemStack.EMPTY;
    }

    public static boolean shuffleInventory(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.shuffleInventory();
        }
        return false;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack itemStack = context.getItemInHand();
        ItemContainerContents items = (ItemContainerContents)itemStack.get(DataComponents.CONTAINER);
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            if (items != null) {
                candyBasketBlockEntity.setItems(items);
            }
        }
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            int count = 0;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (container.getItem(i).isEmpty()) continue;
                ++count;
            }
            if (count > 0) {
                return count * 14 / container.getContainerSize() + 1;
            }
        }
        return 0;
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, state);
        BlockEntityType blockEntityType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.CANDY_BASKET);
        if (blockEntityType != null && level.getBlockEntity(pos) instanceof CandyBasketBlockEntity) {
            level.getBlockEntity(pos, blockEntityType).ifPresent(blockEntity -> blockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess()));
        }
        return itemStack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        for (ItemStack itemStack : ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            tooltipComponents.add(itemStack.getHoverName());
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            if (!level.isClientSide && player.isCreative() && !candyBasketBlockEntity.isEmpty()) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                itemStack.applyComponents(blockEntity.collectComponents());
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
            level.updateNeighborsAt(pos, Blocks.AIR);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.get(DataComponents.CONTAINER) != null && (blockEntity = level.getBlockEntity(pos)) instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            ItemContainerContents items = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            candyBasketBlockEntity.setItems(items);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            super.onRemove(state, level, pos, newState, movedByPiston);
            if (blockEntity instanceof CandyBasketBlockEntity) {
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

