/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class FrightsDelightBubbleParticle
extends TextureSheetParticle {
    protected FrightsDelightBubbleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z);
        this.scale(this.random.nextFloat() * 0.5f + 0.2f);
        this.setSize(0.25f, 0.25f);
        this.xd = xSpeed * 0.10000000298023223 + (this.random.nextDouble() * 0.6 - 0.3) * 0.01;
        this.yd = ySpeed * (double)0.2f + this.random.nextDouble() * 0.009;
        this.zd = zSpeed * 0.10000000298023223 + (this.random.nextDouble() * 0.6 - 0.3) * 0.01;
        this.lifetime = this.random.nextInt(30) + 70;
        this.gravity = 3.0E-6f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd += (double)(this.random.nextFloat() / 10000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 10000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity * 0.5;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.02f;
            }
        } else {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FrightsDelightBubbleParticle particle = new FrightsDelightBubbleParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setAlpha(0.8f);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

