/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.event.neoforge;

import com.chefmooon.frightsdelight.client.gui.neoforge.FrightsDelightGUIImpl;
import com.chefmooon.frightsdelight.client.particle.FrightsDelightBubbleParticle;
import com.chefmooon.frightsdelight.client.renderer.neoforge.LollipopMoldBlockEntityRendererImpl;
import com.chefmooon.frightsdelight.common.fluid.FrDFluidConstants;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightParticleTypes;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightBlockEntitiesImpl;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightEntityTypesImpl;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightFluidTypesImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="frightsdelight", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupEventsImpl {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.SLIME_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.ROTTEN_FLESH_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.SPIDER_EYE_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.SOUL_BERRY_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.WITHER_BERRY_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.COBWEB_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)FrightsDelightParticleTypes.GHAST_TEAR_BUBBLE.get(), FrightsDelightBubbleParticle.Factory::new);
    }

    @SubscribeEvent
    public static void onEntityRendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(FrightsDelightEntityTypesImpl.BONE_SHARD.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        FrightsDelightGUIImpl.register(event);
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(FrightsDelightBlockEntitiesImpl.LOLLIPOP_MOLD.get(), LollipopMoldBlockEntityRendererImpl::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.ROTTEN_FLESH_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.ROTTEN_FLESH_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.ROTTEN_FLESH_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.SLIMEAPPLE_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.SLIMEAPPLE_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.SLIMEAPPLE_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.SPIDEREYE_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.SPIDEREYE_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.SPIDEREYE_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.GHASTTEAR_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.GHASTTEAR_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.GHASTTEAR_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.SOUL_BERRY_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.SOUL_BERRY_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.SOUL_BERRY_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.WITHER_BERRY_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.WITHER_BERRY_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.WITHER_BERRY_SYRUP});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return FrDFluidConstants.Textures.COBWEB_SYRUP_STILL_TEXTURE;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return FrDFluidConstants.Textures.COBWEB_SYRUP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{FrightsDelightFluidTypesImpl.COBWEB_SYRUP});
    }

    private static IClientFluidTypeExtensions createSyrupExtension(final int color) {
        return new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return ResourceLocation.withDefaultNamespace((String)"block/water_still");
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return ResourceLocation.withDefaultNamespace((String)"block/water_flow");
            }

            public int getTintColor() {
                return color;
            }
        };
    }
}

