/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.entity;

import com.mrbysco.slabmachines.config.SlabConfig;
import com.mrbysco.slabmachines.init.SlabRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;

public class TNTSlabEntity
extends PrimedTnt {
    private static final EntityDataAccessor<Boolean> IS_ETHO = SynchedEntityData.defineId(TNTSlabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean etho = false;

    public TNTSlabEntity(EntityType<? extends TNTSlabEntity> type, Level level) {
        super(type, level);
    }

    public TNTSlabEntity(Level level, double x, double y, double z, @Nullable LivingEntity igniter, boolean etho) {
        this(SlabRegistry.TNT_SLAB_ENTITY.get(), level);
        this.setPos(x, y, z);
        double d0 = level.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.owner = igniter;
        this.etho = etho;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_ETHO, (Object)false);
    }

    public void explode() {
        float f = 2.0f;
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), f, Level.ExplosionInteraction.TNT);
        if (!this.level().isClientSide && this.isEtho()) {
            double radius = 6.0f * (0.7f + this.level().random.nextFloat() * 0.6f);
            AABB hitbox = new AABB(this.getX() - 0.5, this.getY() - 0.5, this.getZ() - 0.5, this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5).expandTowards(-radius, -radius, -radius).expandTowards(radius, radius, radius);
            block0: for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, hitbox)) {
                if ((!(entity instanceof Player) || entity instanceof FakePlayer) && (!((Boolean)SlabConfig.COMMON.ethoSlabVillagers.get()).booleanValue() || !(entity instanceof Villager))) continue;
                for (int i = 40; i >= 0; --i) {
                    if (entity.blockPosition().getY() + i > 256) {
                        return;
                    }
                    if (this.level().getBlockState(entity.blockPosition().offset(0, i, 0)).getBlock() != Blocks.AIR) continue;
                    this.level().setBlockAndUpdate(entity.blockPosition().offset(0, i, 0), Blocks.CHIPPED_ANVIL.defaultBlockState());
                    continue block0;
                }
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Etho", this.isEtho());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setEtho(compound.getBoolean("Etho"));
    }

    public void setEtho(boolean isEtho) {
        this.entityData.set(IS_ETHO, (Object)isEtho);
        this.etho = isEtho;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (IS_ETHO.equals(key)) {
            this.etho = this.getEthoDataManager();
        }
    }

    public boolean getEthoDataManager() {
        return (Boolean)this.entityData.get(IS_ETHO);
    }

    public boolean isEtho() {
        return this.etho;
    }
}

