/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.datagen.data;

import com.mrbysco.slabmachines.blocks.TNTSlabBlock;
import com.mrbysco.slabmachines.init.SlabRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SlabLootProvider
extends LootTableProvider {
    public SlabLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(SlabBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    private static class SlabBlockLoot
    extends BlockLootSubProvider {
        protected SlabBlockLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.dropSelf((Block)SlabRegistry.CRAFTING_TABLE_SLAB.get());
            this.dropSelf((Block)SlabRegistry.CARTOGRAPHY_TABLE_SLAB.get());
            this.dropSelf((Block)SlabRegistry.LOOM_SLAB.get());
            this.add((Block)SlabRegistry.FURNACE_SLAB.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)SlabRegistry.BLAST_FURNACE_SLAB.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)SlabRegistry.SMOKER_SLAB.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)SlabRegistry.CHEST_SLAB.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)SlabRegistry.TRAPPED_CHEST_SLAB.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)SlabRegistry.NOTE_SLAB.get());
            this.add((Block)SlabRegistry.TNT_SLAB.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)SlabRegistry.TNT_SLAB.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)SlabRegistry.TNT_SLAB.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)SlabRegistry.TNT_SLAB.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TNTSlabBlock.UNSTABLE, false)))))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return SlabRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

