/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.datagen.assets;

import com.mrbysco.slabmachines.blocks.AbstractFurnaceSlabBlock;
import com.mrbysco.slabmachines.blocks.FurnaceSlabBlock;
import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.blocks.base.FacingMultiSlabBlock;
import com.mrbysco.slabmachines.blocks.base.enums.CustomSlabType;
import com.mrbysco.slabmachines.init.SlabRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SlabBlockstateProvider
extends BlockStateProvider {
    public SlabBlockstateProvider(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "slabmachines", helper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder registryObject : SlabRegistry.BLOCKS.getEntries()) {
            if (!(registryObject.get() instanceof CustomSlabBlock)) continue;
            if (registryObject.get() instanceof FacingMultiSlabBlock) {
                if (registryObject.get() instanceof AbstractFurnaceSlabBlock) {
                    this.generateFurnaceSlab((DeferredHolder<Block, ? extends Block>)registryObject);
                    continue;
                }
                this.generateFacingSlab((DeferredHolder<Block, ? extends Block>)registryObject);
                continue;
            }
            this.generateSlab((DeferredHolder<Block, ? extends Block>)registryObject);
        }
    }

    private void generateSlab(DeferredHolder<Block, ? extends Block> registryObject) {
        ModelFile.ExistingModelFile topModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath() + "_top"));
        ModelFile.ExistingModelFile bottomModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath()));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)registryObject.get()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).modelForState().modelFile((ModelFile)bottomModel).addModel();
    }

    private void generateFacingSlab(DeferredHolder<Block, ? extends Block> registryObject) {
        ModelFile.ExistingModelFile topModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath() + "_top"));
        ModelFile.ExistingModelFile bottomModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath()));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)registryObject.get()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)topModel).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)topModel).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)topModel).rotationY(270).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)bottomModel).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)bottomModel).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)bottomModel).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)bottomModel).rotationY(270).addModel();
    }

    private void generateFurnaceSlab(DeferredHolder<Block, ? extends Block> registryObject) {
        ModelFile.ExistingModelFile topModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath() + "_top"));
        ModelFile.ExistingModelFile bottomModel = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath()));
        ModelFile.ExistingModelFile topModelOn = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath() + "_top_on"));
        ModelFile.ExistingModelFile bottomModelOn = this.models().getExistingFile(this.modLoc("block/" + registryObject.getId().getPath() + "_on"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)registryObject.get()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)topModelOn).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)topModelOn).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)topModelOn).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)topModelOn).rotationY(270).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)bottomModelOn).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)bottomModelOn).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)bottomModelOn).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)bottomModelOn).rotationY(270).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)topModel).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)topModel).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.TOP)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)topModel).rotationY(270).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.EAST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)bottomModel).rotationY(90).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.NORTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)bottomModel).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.SOUTH).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)bottomModel).rotationY(180).addModel()).partialState().with(CustomSlabBlock.TYPE, (Comparable)((Object)CustomSlabType.BOTTOM)).with((Property)FacingMultiSlabBlock.FACING, (Comparable)Direction.WEST).with((Property)FurnaceSlabBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)bottomModel).rotationY(270).addModel();
    }
}

