/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.datagen.assets;

import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.init.SlabRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public class SlabBlockModelProvider
extends BlockModelProvider {
    public SlabBlockModelProvider(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "slabmachines", helper);
    }

    protected void registerModels() {
        this.generateSlab(SlabRegistry.CHEST_SLAB, this.modTexture("chest_slab_bottom"), this.modTexture("chest_slab_top"), this.modTexture("chest_slab_side"), this.modTexture("chest_slab_front"));
        this.generateSlab(SlabRegistry.CRAFTING_TABLE_SLAB, this.mcLoc("block/oak_planks"), this.mcLoc("block/crafting_table_top"), this.modTexture("crafting_table_slab_side"), this.modTexture("crafting_table_slab_front"));
        this.generateSlab(SlabRegistry.CARTOGRAPHY_TABLE_SLAB, this.mcLoc("block/dark_oak_planks"), this.mcLoc("block/cartography_table_top"), this.modTexture("cartography_table_slab_3"), this.modTexture("cartography_table_slab_3"), this.modTexture("cartography_table_slab_1"), this.modTexture("cartography_table_slab_2"));
        this.generateSlab(SlabRegistry.LOOM_SLAB, this.mcLoc("block/loom_bottom"), this.mcLoc("block/loom_top"), this.modTexture("loom_slab_side"), this.modTexture("loom_slab_front"));
        this.generateSlab(SlabRegistry.FURNACE_SLAB, this.mcLoc("block/furnace_top"), this.mcLoc("block/furnace_top"), this.modTexture("furnace_slab_side"), this.modTexture("furnace_slab_front"));
        this.generateFurnaceSlab(SlabRegistry.FURNACE_SLAB, this.mcLoc("block/furnace_top"), this.mcLoc("block/furnace_top"), this.modTexture("furnace_slab_side"), this.modTexture("furnace_slab_front_active"));
        this.generateSlab(SlabRegistry.BLAST_FURNACE_SLAB, this.mcLoc("block/blast_furnace_top"), this.mcLoc("block/blast_furnace_top"), this.modTexture("blast_furnace_slab_side"), this.modTexture("blast_furnace_slab_front"));
        this.generateFurnaceSlab(SlabRegistry.BLAST_FURNACE_SLAB, this.mcLoc("block/blast_furnace_top"), this.mcLoc("block/blast_furnace_top"), this.modTexture("blast_furnace_slab_side"), this.modTexture("blast_furnace_slab_front_active"));
        this.generateSlab(SlabRegistry.SMOKER_SLAB, this.mcLoc("block/smoker_top"), this.mcLoc("block/smoker_top"), this.modTexture("smoker_slab_side"), this.modTexture("smoker_slab_front"));
        this.generateFurnaceSlab(SlabRegistry.SMOKER_SLAB, this.mcLoc("block/smoker_top"), this.mcLoc("block/smoker_top"), this.modTexture("smoker_slab_side"), this.modTexture("smoker_slab_front_active"));
        this.generateSlab(SlabRegistry.NOTE_SLAB, this.mcLoc("block/note_block"), this.mcLoc("block/note_block"), this.modTexture("note_slab_side"), null);
        this.generateSlab(SlabRegistry.TNT_SLAB, this.mcLoc("block/tnt_bottom"), this.mcLoc("block/tnt_top"), this.modTexture("tnt_slab_side"), null);
        this.generateSlab(SlabRegistry.TRAPPED_CHEST_SLAB, this.modTexture("chest_slab_bottom"), this.modTexture("chest_slab_top"), this.modTexture("chest_slab_side"), this.modTexture("trapped_chest_slab_front"));
    }

    private ResourceLocation modTexture(String path) {
        return this.modLoc("block/" + path);
    }

    private void generateSlab(DeferredBlock<? extends CustomSlabBlock> registryObject, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture, @Nullable ResourceLocation frontTexture) {
        String path = registryObject.getId().getPath();
        ResourceLocation frontToUse = frontTexture != null ? frontTexture : sideTexture;
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path, this.modLoc("block/slab_base_bottom"))).texture("particle", frontToUse)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", frontToUse)).texture("east", sideTexture)).texture("south", sideTexture)).texture("west", sideTexture);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path + "_top", this.modLoc("block/slab_base_top"))).texture("particle", frontToUse)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", frontToUse)).texture("east", sideTexture)).texture("south", sideTexture)).texture("west", sideTexture);
    }

    private void generateSlab(DeferredBlock<? extends CustomSlabBlock> registryObject, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation northTexture, ResourceLocation eastTexture, ResourceLocation southTexture, ResourceLocation westTexture) {
        String path = registryObject.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path, this.modLoc("block/slab_base_bottom"))).texture("particle", northTexture)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", northTexture)).texture("east", eastTexture)).texture("south", southTexture)).texture("west", westTexture);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path + "_top", this.modLoc("block/slab_base_top"))).texture("particle", northTexture)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", northTexture)).texture("east", eastTexture)).texture("south", southTexture)).texture("west", westTexture);
    }

    private void generateFurnaceSlab(DeferredBlock<? extends CustomSlabBlock> registryObject, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture, @Nullable ResourceLocation frontTexture) {
        String path = registryObject.getId().getPath();
        ResourceLocation frontToUse = frontTexture != null ? frontTexture : sideTexture;
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path + "_on", this.modLoc("block/slab_base_bottom"))).texture("particle", frontToUse)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", frontToUse)).texture("east", sideTexture)).texture("south", sideTexture)).texture("west", sideTexture);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(path + "_top_on", this.modLoc("block/slab_base_top"))).texture("particle", frontToUse)).texture("down", bottomTexture)).texture("up", topTexture)).texture("north", frontToUse)).texture("east", sideTexture)).texture("south", sideTexture)).texture("west", sideTexture);
    }
}

