/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.datagen;

import com.mrbysco.slabmachines.datagen.assets.SlabBlockModelProvider;
import com.mrbysco.slabmachines.datagen.assets.SlabBlockstateProvider;
import com.mrbysco.slabmachines.datagen.assets.SlabItemModelProvider;
import com.mrbysco.slabmachines.datagen.assets.SlabLanguageProvider;
import com.mrbysco.slabmachines.datagen.data.SlabBlockTagProvider;
import com.mrbysco.slabmachines.datagen.data.SlabItemTagProvider;
import com.mrbysco.slabmachines.datagen.data.SlabLootProvider;
import com.mrbysco.slabmachines.datagen.data.SlabRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SlabDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new SlabRecipeProvider(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new SlabLootProvider(packOutput, lookupProvider));
            SlabBlockTagProvider blockTags = new SlabBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)blockTags);
            generator.addProvider(true, (DataProvider)new SlabItemTagProvider(packOutput, lookupProvider, blockTags.contentsGetter(), helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new SlabLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new SlabBlockModelProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new SlabBlockstateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new SlabItemModelProvider(packOutput, helper));
        }
    }
}

