/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.config;

import com.mrbysco.slabmachines.SlabMachines;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SlabConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        SlabMachines.LOGGER.debug("Loaded Slab Machines' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        SlabMachines.LOGGER.debug("Slab Machines' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue slabFurnaceSlotLimit;
        public final ModConfigSpec.IntValue slabChestSlotLimit;
        public final ModConfigSpec.BooleanValue ethoSlabVillagers;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.slabFurnaceSlotLimit = builder.comment("This setting limits the slab furnace max stacksize to what's filled in [default: 64]").defineInRange("slabFurnaceSlotLimit", 64, 0, 64);
            this.slabChestSlotLimit = builder.comment("This setting limits the slab chest max stacksize to what's filled in [default: 64]").defineInRange("slabChestSlotLimit", 64, 0, 64);
            this.ethoSlabVillagers = builder.comment("Changing this to true will cause the Etho slab to also drop onto Villagers [default: false]").define("ethoSlabVillagers", false);
            builder.pop();
        }
    }
}

