/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.slabmachines.blocks.TNTSlabBlock;
import com.mrbysco.slabmachines.entity.TNTSlabEntity;
import com.mrbysco.slabmachines.init.SlabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TNTPrimeSlabRenderer
extends EntityRenderer<TNTSlabEntity> {
    public TNTPrimeSlabRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
    }

    public void render(TNTSlabEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        int var7 = entityIn.getFuse();
        if ((float)var7 - partialTicks + 1.0f < 10.0f) {
            float var8 = 1.0f - ((float)var7 - partialTicks + 1.0f) / 10.0f;
            var8 = Mth.clamp((float)var8, (float)0.0f, (float)1.0f);
            var8 *= var8;
            var8 *= var8;
            float var9 = 1.0f + var8 * 0.3f;
            poseStack.scale(var9, var9, var9);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TNTPrimeSlabRenderer.renderTntFlash(((TNTSlabBlock)((Object)SlabRegistry.TNT_SLAB.get())).defaultBlockState(), poseStack, bufferSource, packedLightIn, var7 / 5 % 2 == 0);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public static void renderTntFlash(BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, boolean doFullBright) {
        int i = doFullBright ? OverlayTexture.pack((int)OverlayTexture.u((float)1.0f), (int)10) : OverlayTexture.NO_OVERLAY;
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, bufferSource, combinedLight, i);
    }

    public ResourceLocation getTextureLocation(TNTSlabEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

