/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.entity.TNTSlabEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class TNTSlabBlock
extends CustomSlabBlock {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;
    public static final BooleanProperty ETHOSLAB = BooleanProperty.create((String)"etho");

    public TNTSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.instabreak().sound(SoundType.GRASS));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)ETHOSLAB, (Comparable)Boolean.valueOf(false)));
    }

    public void catchFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(world, pos, igniter);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ETHOSLAB, (Comparable)Boolean.valueOf(stack.getHoverName().getString().equalsIgnoreCase("Etho slab")));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && level.hasNeighborSignal(pos)) {
            this.catchFire(state, level, pos, null, null);
            level.removeBlock(pos, false);
        }
    }

    public boolean isEthoSlab(Level level, BlockPos pos) {
        BlockState partState = level.getBlockState(pos);
        boolean etho = false;
        if (partState.getProperties().contains(ETHOSLAB)) {
            etho = (Boolean)partState.getValue((Property)ETHOSLAB);
        }
        return etho;
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosionIn) {
        if (!level.isClientSide) {
            TNTSlabEntity tntentity = new TNTSlabEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosionIn.getIndirectSourceEntity(), this.isEthoSlab(level, pos));
            tntentity.setFuse((short)(level.random.nextInt(tntentity.getFuse() / 4) + tntentity.getFuse() / 8));
            level.addFreshEntity((Entity)tntentity);
        }
    }

    public void explode(Level level, BlockPos pos, LivingEntity igniter) {
        if (!level.isClientSide) {
            TNTSlabEntity tntentity = new TNTSlabEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, igniter, this.isEthoSlab(level, pos));
            level.addFreshEntity((Entity)tntentity);
            level.playSound((Player)null, tntentity.getX(), tntentity.getY(), tntentity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{TYPE, WATERLOGGED, UNSTABLE, ETHOSLAB});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.getItemInHand(handIn);
        Item item = itemstack.getItem();
        if (item != Items.FLINT_AND_STEEL && item != Items.FIRE_CHARGE) {
            return super.useItemOn(stack, state, level, pos, player, handIn, hit);
        }
        this.catchFire(state, level, pos, hit.getDirection(), (LivingEntity)player);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!player.isCreative()) {
            if (item == Items.FLINT_AND_STEEL) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)handIn));
            } else {
                itemstack.shrink(1);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.isClientSide) {
            Entity entity = projectile.getOwner();
            if (projectile.isOnFire()) {
                BlockPos blockpos = hit.getBlockPos();
                this.catchFire(state, level, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                level.removeBlock(blockpos, false);
            }
        }
    }

    public boolean dropFromExplosion(@NotNull Explosion explosionIn) {
        return false;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.hasNeighborSignal(pos)) {
            this.catchFire(state, level, pos, null, null);
            level.removeBlock(pos, false);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

