/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blockentity.furnace.SmokerSlabBlockEntity;
import com.mrbysco.slabmachines.blocks.AbstractFurnaceSlabBlock;
import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.blocks.base.enums.CustomSlabType;
import com.mrbysco.slabmachines.init.SlabRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SmokerSlabBlock
extends AbstractFurnaceSlabBlock {
    public SmokerSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f, 10.0f).sound(SoundType.STONE));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SmokerSlabBlockEntity) {
            SmokerSlabBlockEntity smokerBlockEntity = (SmokerSlabBlockEntity)blockEntity;
            player.openMenu((MenuProvider)smokerBlockEntity);
            player.awardStat(Stats.INTERACT_WITH_SMOKER);
        }
        return InteractionResult.CONSUME;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double posX = (double)pos.getX() + 0.5;
            double posY = (double)pos.getY() + (stateIn.getValue(CustomSlabBlock.TYPE) == CustomSlabType.TOP ? 0.5 : 0.0);
            double posZ = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.playLocalSound(posX, posY, posZ, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, posX, posY + 1.1, posZ, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SmokerSlabBlock.createFurnaceTicker(level, blockEntityType, SlabRegistry.SMOKER_SLAB_BE.get());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmokerSlabBlockEntity(pos, state);
    }
}

