/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.NoteBlockEvent;

public class NoteBlockSlab
extends CustomSlabBlock {
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.NOTEBLOCK_INSTRUMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;

    public NoteBlockSlab(BlockBehaviour.Properties properties) {
        super(properties.strength(2.5f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(INSTRUMENT, (Comparable)NoteBlockInstrument.HARP)).setValue((Property)NOTE, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.setInstrument((LevelAccessor)context.getLevel(), context.getClickedPos(), super.getStateForPlacement(context));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        boolean flag = direction.getAxis() == Direction.Axis.Y;
        BlockState noteState = flag ? this.setInstrument(level, pos, state) : super.updateShape(state, direction, state1, level, pos, pos1);
        return direction == Direction.DOWN ? noteState : super.updateShape(state, direction, state1, level, pos, pos1);
    }

    private BlockState setInstrument(LevelAccessor accessor, BlockPos pos, BlockState state) {
        NoteBlockInstrument noteblockinstrument = accessor.getBlockState(pos.above()).instrument();
        if (noteblockinstrument.worksAboveNoteBlock()) {
            return (BlockState)state.setValue(INSTRUMENT, (Comparable)noteblockinstrument);
        }
        NoteBlockInstrument noteblockinstrument1 = accessor.getBlockState(pos.below()).instrument();
        NoteBlockInstrument noteblockinstrument2 = noteblockinstrument1.worksAboveNoteBlock() ? NoteBlockInstrument.HARP : noteblockinstrument1;
        return (BlockState)state.setValue(INSTRUMENT, (Comparable)noteblockinstrument2);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(ItemTags.NOTE_BLOCK_TOP_INSTRUMENTS) && result.getDirection() == Direction.UP) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        int _new = CommonHooks.onNoteChange((Level)level, (BlockPos)pos, (BlockState)state, (int)((Integer)state.getValue((Property)NOTE)), (int)((Integer)((BlockState)state.cycle((Property)NOTE)).getValue((Property)NOTE)));
        if (_new == -1) {
            return ItemInteractionResult.FAIL;
        }
        state = (BlockState)state.setValue((Property)NOTE, (Comparable)Integer.valueOf(_new));
        level.setBlock(pos, state, 3);
        this.playNote((Entity)player, state, level, pos);
        player.awardStat(Stats.TUNE_NOTEBLOCK);
        return ItemInteractionResult.CONSUME;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            this.playNote((Entity)player, state, level, pos);
            player.awardStat(Stats.PLAY_NOTEBLOCK);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)POWERED)) {
            if (flag) {
                this.playNote(null, state, level, pos);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    private void playNote(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (((NoteBlockInstrument)state.getValue(INSTRUMENT)).worksAboveNoteBlock() || level.getBlockState(pos.above()).isAir()) {
            level.blockEvent(pos, (Block)this, 0, 0);
            level.gameEvent(entity, (Holder)GameEvent.NOTE_BLOCK_PLAY, pos);
        }
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        Holder holder;
        float f;
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(level, pos, state, ((Integer)state.getValue((Property)NOTE)).intValue(), (NoteBlockInstrument)state.getValue(INSTRUMENT));
        if (((NoteBlockEvent.Play)NeoForge.EVENT_BUS.post((Event)e)).isCanceled()) {
            return false;
        }
        NoteBlockInstrument noteblockinstrument = (NoteBlockInstrument)(state = (BlockState)((BlockState)state.setValue((Property)NOTE, (Comparable)Integer.valueOf(e.getVanillaNoteId()))).setValue(INSTRUMENT, (Comparable)e.getInstrument())).getValue(INSTRUMENT);
        if (noteblockinstrument.isTunable()) {
            int i = (Integer)state.getValue((Property)NOTE);
            f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)i / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        if (noteblockinstrument.hasCustomSound()) {
            ResourceLocation resourcelocation = this.getCustomSoundId(level, pos);
            if (resourcelocation == null) {
                return false;
            }
            holder = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)resourcelocation));
        } else {
            holder = noteblockinstrument.getSoundEvent();
        }
        level.playSeededSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, holder, SoundSource.RECORDS, 3.0f, f, level.random.nextLong());
        return true;
    }

    @Nullable
    private ResourceLocation getCustomSoundId(Level level, BlockPos pos) {
        BlockEntity blockentity = level.getBlockEntity(pos.above());
        if (blockentity instanceof SkullBlockEntity) {
            SkullBlockEntity skullblockentity = (SkullBlockEntity)blockentity;
            return skullblockentity.getNoteBlockSound();
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{TYPE, WATERLOGGED, INSTRUMENT, POWERED, NOTE});
    }
}

