/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blockentity.furnace.BlastFurnaceSlabBlockEntity;
import com.mrbysco.slabmachines.blocks.AbstractFurnaceSlabBlock;
import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.blocks.base.enums.CustomSlabType;
import com.mrbysco.slabmachines.init.SlabRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlastFurnaceSlabBlock
extends AbstractFurnaceSlabBlock {
    public BlastFurnaceSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f, 10.0f).sound(SoundType.STONE));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlastFurnaceSlabBlockEntity) {
            BlastFurnaceSlabBlockEntity blastFurnaceBlockEntity = (BlastFurnaceSlabBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blastFurnaceBlockEntity);
            player.awardStat(Stats.INTERACT_WITH_BLAST_FURNACE);
        }
        return InteractionResult.CONSUME;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double posX = (double)pos.getX() + 0.5;
            double posY = (double)pos.getY() + (stateIn.getValue(CustomSlabBlock.TYPE) == CustomSlabType.TOP ? 0.5 : 0.0);
            double posZ = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.playLocalSound(posX, posY, posZ, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.getValue((Property)FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * d3 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * d3 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, posX + d5, posY + d6, posZ + d7, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, posX + d5, posY + d6, posZ + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlastFurnaceSlabBlock.createFurnaceTicker(level, blockEntityType, SlabRegistry.BLAST_FURNACE_SLAB_BE.get());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlastFurnaceSlabBlockEntity(pos, state);
    }
}

