/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.renderer;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.client.model.GrapplingHookModel;
import com.github.eterdelta.crittersandcompanions.entity.GrapplingHookEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GrapplingHookRenderer
extends EntityRenderer<GrapplingHookEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(CrittersAndCompanions.createId("grappling_hook"), "main");
    private static final ResourceLocation TEXTURE = CrittersAndCompanions.createId("textures/entity/grappling_hook.png");
    private final GrapplingHookModel<GrapplingHookEntity> hookModel;

    public GrapplingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.hookModel = new GrapplingHookModel(context.bakeLayer(LAYER_LOCATION));
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer vertexConsumer, PoseStack.Pose pose, float p_174124_, float p_174125_) {
        float f = p_174119_ * p_174124_;
        float f1 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float f2 = p_174121_ * p_174124_;
        float f3 = p_174119_ * p_174125_ - f;
        float f4 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - f1;
        float f5 = p_174121_ * p_174125_ - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        vertexConsumer.addVertex(pose.pose(), f, f1, f2).setColor(193, 184, 205, 255).setNormal(pose, f3 /= f6, f4 /= f6, f5 /= f6);
    }

    public void render(GrapplingHookEntity entity, float p_114706_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Player player = (Player)entity.getOwner();
        if (player != null && entity.isFocused()) {
            float f3;
            double d6;
            double d5;
            double d4;
            int handOffset;
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.translate(0.0, -1.25, 0.0);
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
            this.hookModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
            int n = handOffset = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            if (!player.getMainHandItem().is(entity.getItem().getItem())) {
                handOffset = -handOffset;
            }
            float f = player.getAttackAnim(partialTicks);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f2 = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)handOffset * 0.35;
            if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
                double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)handOffset * 0.825f, -0.08f);
                vec3 = vec3.scale(d7);
                vec3 = vec3.yRot(f1 * 0.5f);
                vec3 = vec3.xRot(-f1 * 0.7f);
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + vec3.x;
                d5 = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + vec3.y;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + vec3.z;
                f3 = player.getEyeHeight();
            } else {
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.8;
                d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTicks - 0.45;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.8;
                f3 = player.isCrouching() ? -0.1875f : 0.0f;
            }
            double hookPosX = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
            double hookPosY = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + 0.4;
            double hookPosZ = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
            float f4 = (float)(d4 - hookPosX);
            float f5 = (float)(d5 - hookPosY) + f3;
            float f6 = (float)(d6 - hookPosZ);
            VertexConsumer stringVertexConsumer = bufferSource.getBuffer(RenderType.lineStrip());
            PoseStack.Pose pose = poseStack.last();
            GrapplingHookRenderer.stringVertex(f4, f5, f6, stringVertexConsumer, pose, 0.0f, 1.0f);
            GrapplingHookRenderer.stringVertex(f4, f5, f6, stringVertexConsumer, pose, 1.0f, 2.0f);
            poseStack.popPose();
            super.render((Entity)entity, p_114706_, partialTicks, poseStack, bufferSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(GrapplingHookEntity entity) {
        return TEXTURE;
    }
}

