/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util.packed;

import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.ArrayUtil;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;
import org.apache.lucene.ars_nouveau.util.packed.PackedInts;
import org.apache.lucene.ars_nouveau.util.packed.PackedLongValues;

class DeltaPackedLongValues
extends PackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DeltaPackedLongValues.class);
    final long[] mins;

    DeltaPackedLongValues(int pageShift, int pageMask, PackedInts.Reader[] values, long[] mins, long size, long ramBytesUsed) {
        super(pageShift, pageMask, values, size, ramBytesUsed);
        assert (values.length == mins.length);
        this.mins = mins;
    }

    @Override
    long get(int block, int element) {
        return this.mins[block] + this.values[block].get(element);
    }

    @Override
    int decodeBlock(int block, long[] dest) {
        int count = super.decodeBlock(block, dest);
        long min = this.mins[block];
        int i = 0;
        while (i < count) {
            int n = i++;
            dest[n] = dest[n] + min;
        }
        return count;
    }

    static class Builder
    extends PackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        long[] mins;

        Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.mins = new long[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public DeltaPackedLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values = ArrayUtil.copyOfSubArray(this.values, 0, this.valuesOff);
            long[] mins = ArrayUtil.copyOfSubArray(this.mins, 0, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values) + RamUsageEstimator.sizeOf(mins);
            return new DeltaPackedLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values, mins, this.size, ramBytesUsed);
        }

        @Override
        void pack(long[] values, int numValues, int block, float acceptableOverheadRatio) {
            int i;
            long min = values[0];
            for (i = 1; i < numValues; ++i) {
                min = Math.min(min, values[i]);
            }
            i = 0;
            while (i < numValues) {
                int n = i++;
                values[n] = values[n] - min;
            }
            super.pack(values, numValues, block, acceptableOverheadRatio);
            this.mins[block] = min;
        }

        @Override
        void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.mins);
            this.mins = ArrayUtil.growExact(this.mins, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }
    }
}

