/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.ars_nouveau.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.ars_nouveau.codecs.KnnVectorsFormat;
import org.apache.lucene.ars_nouveau.codecs.KnnVectorsReader;
import org.apache.lucene.ars_nouveau.codecs.KnnVectorsWriter;
import org.apache.lucene.ars_nouveau.index.ByteVectorValues;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.FloatVectorValues;
import org.apache.lucene.ars_nouveau.index.MergeState;
import org.apache.lucene.ars_nouveau.index.SegmentReadState;
import org.apache.lucene.ars_nouveau.index.SegmentWriteState;
import org.apache.lucene.ars_nouveau.index.Sorter;
import org.apache.lucene.ars_nouveau.internal.hppc.IntObjectHashMap;
import org.apache.lucene.ars_nouveau.internal.hppc.ObjectCursor;
import org.apache.lucene.ars_nouveau.search.KnnCollector;
import org.apache.lucene.ars_nouveau.util.Bits;
import org.apache.lucene.ars_nouveau.util.IOUtils;

public abstract class PerFieldKnnVectorsFormat
extends KnnVectorsFormat {
    public static final String PER_FIELD_NAME = "PerFieldVectors90";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldKnnVectorsFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldKnnVectorsFormat.class.getSimpleName() + ".suffix";

    protected PerFieldKnnVectorsFormat() {
        super(PER_FIELD_NAME);
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new FieldsWriter(state);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return this.getKnnVectorsFormatForField(fieldName).getMaxDimensions(fieldName);
    }

    public abstract KnnVectorsFormat getKnnVectorsFormatForField(String var1);

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    static String getFullSegmentSuffix(String outerSegmentSuffix, String segmentSuffix) {
        if (outerSegmentSuffix.length() == 0) {
            return segmentSuffix;
        }
        return outerSegmentSuffix + "_" + segmentSuffix;
    }

    private class FieldsWriter
    extends KnnVectorsWriter {
        private final Map<KnnVectorsFormat, WriterAndSuffix> formats;
        private final Map<String, Integer> suffixes = new HashMap<String, Integer>();
        private final SegmentWriteState segmentWriteState;

        FieldsWriter(SegmentWriteState segmentWriteState) {
            this.segmentWriteState = segmentWriteState;
            this.formats = new HashMap<KnnVectorsFormat, WriterAndSuffix>();
        }

        @Override
        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            KnnVectorsWriter writer = this.getInstance(fieldInfo);
            return writer.addField(fieldInfo);
        }

        @Override
        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            for (WriterAndSuffix was : this.formats.values()) {
                was.writer.flush(maxDoc, sortMap);
            }
        }

        @Override
        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.getInstance(fieldInfo).mergeOneField(fieldInfo, mergeState);
        }

        @Override
        public void finish() throws IOException {
            for (WriterAndSuffix was : this.formats.values()) {
                was.writer.finish();
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        private KnnVectorsWriter getInstance(FieldInfo field) throws IOException {
            Integer suffix;
            KnnVectorsFormat format = PerFieldKnnVectorsFormat.this.getKnnVectorsFormatForField(field.name);
            if (format == null) {
                throw new IllegalStateException("invalid null KnnVectorsFormat for field=\"" + field.name + "\"");
            }
            String formatName = format.getName();
            field.putAttribute(PER_FIELD_FORMAT_KEY, formatName);
            WriterAndSuffix writerAndSuffix = this.formats.get(format);
            if (writerAndSuffix == null) {
                suffix = this.suffixes.get(formatName);
                suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                this.suffixes.put(formatName, suffix);
                String segmentSuffix = PerFieldKnnVectorsFormat.getFullSegmentSuffix(this.segmentWriteState.segmentSuffix, PerFieldKnnVectorsFormat.getSuffix(formatName, Integer.toString(suffix)));
                writerAndSuffix = new WriterAndSuffix(format.fieldsWriter(new SegmentWriteState(this.segmentWriteState, segmentSuffix)), suffix);
                this.formats.put(format, writerAndSuffix);
            } else {
                assert (this.suffixes.containsKey(formatName));
                suffix = writerAndSuffix.suffix;
            }
            field.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(suffix));
            return writerAndSuffix.writer;
        }

        @Override
        public long ramBytesUsed() {
            long total = 0L;
            for (WriterAndSuffix was : this.formats.values()) {
                total += was.writer.ramBytesUsed();
            }
            return total;
        }
    }

    public static class FieldsReader
    extends KnnVectorsReader {
        private final IntObjectHashMap<KnnVectorsReader> fields = new IntObjectHashMap();
        private final FieldInfos fieldInfos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FieldsReader(SegmentReadState readState) throws IOException {
            this.fieldInfos = readState.fieldInfos;
            boolean success = false;
            HashMap<String, KnnVectorsReader> formats = new HashMap<String, KnnVectorsReader>();
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (!fi.hasVectorValues()) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    if (suffix == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + fieldName);
                    }
                    KnnVectorsFormat format = KnnVectorsFormat.forName(formatName);
                    String segmentSuffix = PerFieldKnnVectorsFormat.getFullSegmentSuffix(readState.segmentSuffix, PerFieldKnnVectorsFormat.getSuffix(formatName, suffix));
                    if (!formats.containsKey(segmentSuffix)) {
                        formats.put(segmentSuffix, format.fieldsReader(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fi.number, (KnnVectorsReader)formats.get(segmentSuffix));
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(formats.values());
                }
            }
        }

        private FieldsReader(FieldsReader fieldsReader) {
            this.fieldInfos = fieldsReader.fieldInfos;
            for (FieldInfo fi : this.fieldInfos) {
                if (!fi.hasVectorValues() || !fieldsReader.fields.containsKey(fi.number)) continue;
                this.fields.put(fi.number, fieldsReader.fields.get(fi.number).getMergeInstance());
            }
        }

        @Override
        public KnnVectorsReader getMergeInstance() {
            return new FieldsReader(this);
        }

        @Override
        public void finishMerge() throws IOException {
            for (ObjectCursor knnVectorReader : this.fields.values()) {
                ((KnnVectorsReader)knnVectorReader.value).finishMerge();
            }
        }

        public KnnVectorsReader getFieldReader(String field) {
            FieldInfo info = this.fieldInfos.fieldInfo(field);
            if (info == null) {
                return null;
            }
            return this.fields.get(info.number);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (ObjectCursor cursor : this.fields.values()) {
                ((KnnVectorsReader)cursor.value).checkIntegrity();
            }
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            KnnVectorsReader reader;
            FieldInfo info = this.fieldInfos.fieldInfo(field);
            if (info == null || (reader = this.fields.get(info.number)) == null) {
                return null;
            }
            return reader.getFloatVectorValues(field);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            KnnVectorsReader reader;
            FieldInfo info = this.fieldInfos.fieldInfo(field);
            if (info == null || (reader = this.fields.get(info.number)) == null) {
                return null;
            }
            return reader.getByteVectorValues(field);
        }

        @Override
        public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            KnnVectorsReader reader;
            FieldInfo info = this.fieldInfos.fieldInfo(field);
            if (info == null || (reader = this.fields.get(info.number)) == null) {
                return;
            }
            reader.search(field, target, knnCollector, acceptDocs);
        }

        @Override
        public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            KnnVectorsReader reader;
            FieldInfo info = this.fieldInfos.fieldInfo(field);
            if (info == null || (reader = this.fields.get(info.number)) == null) {
                return;
            }
            reader.search(field, target, knnCollector, acceptDocs);
        }

        @Override
        public void close() throws IOException {
            ArrayList<KnnVectorsReader> readers = new ArrayList<KnnVectorsReader>(this.fields.size());
            for (ObjectCursor cursor : this.fields.values()) {
                readers.add((KnnVectorsReader)cursor.value);
            }
            IOUtils.close(readers);
        }
    }

    private record WriterAndSuffix(KnnVectorsWriter writer, int suffix) implements Closeable
    {
        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

