/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.pt;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.pt.PortugueseLightStemmer;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.KeywordAttribute;

public final class PortugueseLightStemFilter
extends TokenFilter {
    private final PortugueseLightStemmer stemmer = new PortugueseLightStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public PortugueseLightStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

