/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.saved_data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class DimMappingData
extends SavedData {
    private final Map<String, Entry> DIMENSIONS_BY_NAME = new HashMap<String, Entry>();
    private final Map<ResourceLocation, Entry> DIMENSIONS_BY_KEY = new HashMap<ResourceLocation, Entry>();

    public static SavedData.Factory<DimMappingData> factory() {
        return new SavedData.Factory(DimMappingData::new, DimMappingData::load, null);
    }

    public Entry getOrCreateByName(String name) {
        if (this.DIMENSIONS_BY_NAME.containsKey(name)) {
            return this.DIMENSIONS_BY_NAME.get(name);
        }
        Entry entry = new Entry(name, ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)UUID.randomUUID().toString().toLowerCase()));
        this.DIMENSIONS_BY_NAME.put(name, entry);
        this.DIMENSIONS_BY_KEY.put(entry.key, entry);
        return entry;
    }

    public Entry getByKey(ResourceLocation key) {
        return this.DIMENSIONS_BY_KEY.get(key);
    }

    public static DimMappingData load(CompoundTag tag, HolderLookup.Provider p_323806_) {
        DimMappingData data = new DimMappingData();
        ListTag signalList = tag.getList("DimList", 10);
        for (int i = 0; i < signalList.size(); ++i) {
            Entry signal = new Entry(signalList.getCompound(i));
            data.DIMENSIONS_BY_NAME.put(signal.name, signal);
            data.DIMENSIONS_BY_KEY.put(signal.key, signal);
        }
        return data;
    }

    public boolean isDirty() {
        return true;
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        ListTag signalList = new ListTag();
        for (Entry signal : this.DIMENSIONS_BY_NAME.values()) {
            signalList.add((Object)signal.save(new CompoundTag()));
        }
        pCompoundTag.put("DimList", (Tag)signalList);
        return pCompoundTag;
    }

    public static DimMappingData from(ServerLevel level) {
        return (DimMappingData)level.getServer().overworld().getDataStorage().computeIfAbsent(DimMappingData.factory(), "an_dimensions");
    }

    public record Entry(String name, ResourceLocation key) {
        public Entry(CompoundTag tag) {
            this(tag.getString("name"), ResourceLocation.parse((String)tag.getString("key")));
        }

        public CompoundTag save(CompoundTag tag) {
            tag.putString("name", this.name);
            tag.putString("key", this.key.toString());
            return tag;
        }
    }
}

