/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.PlanariumTile;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PacketUpdateDimTile
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketUpdateDimTile> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_planarium"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateDimTile> CODEC = StreamCodec.ofMember(PacketUpdateDimTile::toBytes, PacketUpdateDimTile::new);
    public BlockPos pos;
    public StructureTemplate structureTemplate;

    public PacketUpdateDimTile(BlockPos pos, StructureTemplate structureTemplate) {
        this.pos = pos;
        this.structureTemplate = structureTemplate;
    }

    public PacketUpdateDimTile(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.structureTemplate = new StructureTemplate();
        this.structureTemplate.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)buf.readNbt(NbtAccounter.unlimitedHeap()));
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.structureTemplate.save(new CompoundTag()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        ClientLevel world = minecraft.level;
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof PlanariumTile) {
            PlanariumTile planariumTile = (PlanariumTile)blockEntity;
            planariumTile.setTemplateClientSide(this.structureTemplate);
        }
    }
}

