/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.EmitterProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class SnowstormParticle
extends TextureSheetParticle {
    public static final float TIME_SCALE = 0.05f;
    private Vector3f acceleration = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f speed = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    protected PropertyParticleOptions propertyParticleOptions;
    float phase = (float)Math.random() * 2.0f * (float)Math.PI;
    private static final double MAX_COLLISION_VELOCITY = Mth.square((double)100.0);

    protected SnowstormParticle(PropertyParticleOptions propertyParticleOptions, ClientLevel level, double x, double y, double z) {
        this(propertyParticleOptions, level, x, y, z, 0.0, 0.0, 0.0);
    }

    protected SnowstormParticle(PropertyParticleOptions propertyParticleOptions, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        Vec3 pointOffset = this.getPointSpawnOffset();
        this.setPos(x + pointOffset.x, y + pointOffset.y, z + pointOffset.z);
        this.propertyParticleOptions = propertyParticleOptions;
        this.position.set(x, y, z);
        Vector3f dir = Direction.NORTH.step().rotateX(1.5707964f).rotateY((float)Math.PI);
        if (propertyParticleOptions.map.has((IPropertyType)ParticlePropertyRegistry.EMITTER_PROPERTY.get())) {
            Vec2 rotation = ((EmitterProperty)propertyParticleOptions.map.get((IPropertyType)ParticlePropertyRegistry.EMITTER_PROPERTY.get())).rotation;
            dir = Direction.NORTH.step().rotateX(rotation.x * ((float)Math.PI / 180)).rotateY(rotation.y * ((float)Math.PI / 180));
        }
        float initSpeed = 6.0f;
        this.speed.set(dir.x * initSpeed, dir.y * initSpeed, dir.z * initSpeed);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        ++this.age;
        if (this.age > this.lifetime) {
            this.remove();
        }
        this.xo = this.position.x;
        this.yo = this.position.y;
        this.zo = this.position.z;
        Vector3f thisTickAccel = new Vector3f(0.0f, 0.0f, 0.0f);
        this.acceleration.x = thisTickAccel.x;
        this.acceleration.y = thisTickAccel.y;
        this.acceleration.z = thisTickAccel.z;
        float dragCoefficient = this.airDrag();
        this.acceleration.add(this.speed.x * -dragCoefficient, this.speed.y * -dragCoefficient, this.speed.z * -dragCoefficient);
        this.speed.add(this.acceleration.x * 0.05f, this.acceleration.y * 0.05f, this.acceleration.z * 0.05f);
        this.position.add(this.speed.x * 0.05f, this.speed.y * 0.05f, this.speed.z * 0.05f);
        this.move(this.speed.x * 0.05f, this.speed.y * 0.05f, this.speed.z * 0.05f);
        float swirlSpeed = 0.1f;
        float baseRadius = 1.0f;
        float radiusWobbleAmp = 0.015000001f;
        float radiusWobbleFreq = 0.075f;
        float fallSpeed = 0.05f;
        float verticalWobbleAmp = 0.2f;
        float verticalWobbleFreq = 0.15f;
        float jitterAmp = 0.05f;
        double angle = Math.PI * 2 * (double)swirlSpeed * (double)this.age + (double)this.phase;
        double radius = (double)baseRadius + (double)radiusWobbleAmp * Math.sin(Math.PI * 2 * (double)radiusWobbleFreq * (double)this.age);
        double x = radius * Math.cos(angle);
        double z = radius * Math.sin(angle);
        double y = (double)(-fallSpeed * (float)this.age) + (double)verticalWobbleAmp * Math.sin(Math.PI * 2 * (double)verticalWobbleFreq * (double)this.age);
        this.setPos(this.position.x, (double)this.position.y + y / 20.0, this.position.z);
    }

    public abstract Vector3f getAcceleration();

    public abstract float airDrag();

    public void move(double nx, double ny, double nz) {
        if (this.hasPhysics && (nx != 0.0 || ny != 0.0 || nz != 0.0) && nx * nx + ny * ny + nz * nz < MAX_COLLISION_VELOCITY) {
            boolean collided;
            AABB bb = this.getBoundingBox();
            Vec3 correctedSpeedFactor = Entity.collideBoundingBox(null, (Vec3)new Vec3(nx, ny, nz), (AABB)bb, (Level)this.level, List.of());
            boolean xc = correctedSpeedFactor.x != nx;
            boolean yc = correctedSpeedFactor.y != ny;
            boolean zc = correctedSpeedFactor.z != nz;
            boolean bl = collided = xc || yc || zc;
            if (collided) {
                float bounciness = this.bounciness();
                if (this.expireOnCollide()) {
                    this.remove();
                }
                if (xc) {
                    this.speed.x *= -1.0f;
                }
                if (yc) {
                    this.speed.y *= -1.0f;
                }
                if (zc) {
                    this.speed.z *= -1.0f;
                }
                this.position.y = (float)(this.yo + correctedSpeedFactor.y);
                this.speed.y *= bounciness;
                this.speed.x = (float)Mth.sign((double)this.speed.x) * Mth.clamp((float)(Math.abs(this.speed.x) - this.collisionDrag() * 0.05f), (float)0.0f, (float)Float.POSITIVE_INFINITY);
                this.speed.z = (float)Mth.sign((double)this.speed.z) * Mth.clamp((float)(Math.abs(this.speed.z) - this.collisionDrag() * 0.05f), (float)0.0f, (float)Float.POSITIVE_INFINITY);
            }
        }
    }

    public boolean expireOnCollide() {
        return false;
    }

    public float collisionDrag() {
        return 0.0f;
    }

    public float bounciness() {
        return 0.0f;
    }

    public int ageSeconds() {
        return this.age * 20;
    }

    public Vec3 getPointSpawnOffset() {
        return new Vec3(0.0, 0.0, 0.0);
    }
}

