/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core.network;

import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.core.CSRegistry;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ToggleColorless(boolean enabled) implements CustomPacketPayload
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToggleColorless.class);
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleColorless> STREAM_CODEC = CustomPacketPayload.codec(ToggleColorless::encode, ToggleColorless::new);
    public static final CustomPacketPayload.Type<ToggleColorless> TYPE = new CustomPacketPayload.Type(Crystalix.rl("toggle_colorless"));

    private ToggleColorless(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBoolean());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.enabled);
    }

    public static void handle(ToggleColorless message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp;
            if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack wand = CrystalixWand.find((Player)player);
                if (wand.isEmpty()) {
                    return;
                }
                wand.set(CSRegistry.APPLY_COLORLESS, (Object)message.enabled());
                player.displayClientMessage((Component)CSLanguage.PROPERTY_APPLY_COLORLESS.text(ChatFormatting.GRAY, message.enabled() ? CSLanguage.PROPERTY_ENABLED.text(ChatFormatting.DARK_GREEN) : CSLanguage.PROPERTY_DISABLED.text(ChatFormatting.DARK_RED)), true);
                player.getInventory().setChanged();
            }
        }).exceptionally(e -> {
            log.error("Failed to pick wand properties from BlockState", e);
            return null;
        });
    }
}

