/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.properties;

import com.google.common.base.Suppliers;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.properties.IProperty;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CSBooleanProperty
implements IProperty<Boolean> {
    private final ItemStack stack;
    private final ResourceLocation location;
    private final String translation;
    private final CSTranslatable description;
    private final String key;
    private final Supplier<DataComponentType<Boolean>> type;
    private Boolean value;

    protected CSBooleanProperty(ItemStack stack, CSTranslatable translation, CSTranslatable description, ResourceLocation location, boolean defaultValue, Supplier<DataComponentType<Boolean>> supplier) {
        this.stack = stack;
        this.location = location;
        this.translation = translation.translation();
        this.description = description;
        this.key = translation.key();
        this.type = Suppliers.memoize(supplier::get);
        this.value = (Boolean)stack.getOrDefault(this.type, (Object)defaultValue);
    }

    public static CSBooleanProperty create(ItemStack stack, CSTranslatable translation, CSTranslatable description, ResourceLocation location, boolean defaultValue, Supplier<DataComponentType<Boolean>> supplier) {
        return new CSBooleanProperty(stack, translation, description, location, defaultValue, supplier);
    }

    @Override
    public Boolean next(boolean forward) {
        return this.set(this.value == false);
    }

    @Override
    public Boolean set(Boolean value) {
        this.value = value;
        this.stack.set(this.type, (Object)this.value);
        return this.value;
    }

    @Override
    public DataComponentType<Boolean> type() {
        return this.type.get();
    }

    @Override
    public MutableComponent name() {
        return Component.translatable((String)this.key);
    }

    @Override
    public MutableComponent display() {
        return this.value != false ? CSLanguage.PROPERTY_ENABLED.text(ChatFormatting.DARK_GREEN) : CSLanguage.PROPERTY_DISABLED.text(ChatFormatting.DARK_RED);
    }

    @Override
    public MutableComponent tooltip() {
        return this.description.text();
    }

    @Override
    @Generated
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    @Generated
    public String translation() {
        return this.translation;
    }

    @Override
    @Generated
    public String key() {
        return this.key;
    }

    @Override
    @Generated
    public Boolean value() {
        return this.value;
    }
}

