/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.network.CSNetwork;
import dev.satherov.crystalix.core.network.SetColorPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ColorPickerScreen
extends Screen {
    private static final int BORDER = 1;
    private static final int PADDING = 6;
    private static final int PANEL_PADDING = 10;
    private static final int SV_SIZE = 180;
    private static final int HUE_WIDTH = 18;
    private static final int PREVIEW_HEIGHT = 18;
    private static final int TEXT_HEIGHT = 16;
    private boolean isDraggingColor = false;
    private boolean isDraggingHue = false;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float value = 1.0f;
    private DynamicTexture hueTexture;
    private ResourceLocation hueTextureId;
    private boolean isHueBuilt = false;
    private DynamicTexture svTexture;
    private ResourceLocation svTextureId;
    private float svCache = 1.6777215E7f;
    private boolean isSvDirty = false;
    private EditBox textbox;
    private boolean isUpdating = false;

    protected ColorPickerScreen() {
        super((Component)Component.literal((String)"Color Selection"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int width() {
        return 224;
    }

    private int height() {
        return 246;
    }

    private int svX() {
        return (this.width - this.width()) / 2 + 10;
    }

    private int svY() {
        return (this.height - this.height()) / 2 + 10;
    }

    private int hueX() {
        return this.svX() + 180 + 6;
    }

    private int hueY() {
        return this.svY();
    }

    protected void init() {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        ItemStack wand = CrystalixWand.find((Player)Minecraft.getInstance().player);
        if (wand.isEmpty()) {
            return;
        }
        Integer color = (Integer)wand.get(CSRegistry.COLOR);
        if (color != null) {
            this.rgb(color);
        }
        int x0 = (this.width - this.width()) / 2;
        int svX = x0 + 10;
        int hueX = svX + 180 + 6;
        int previewY = (this.height - this.height()) / 2 + 10 + 180 + 6;
        int textY = previewY + 20 + 4;
        int fieldX1 = svX;
        int fieldW = hueX + 18 - svX;
        this.textbox = new EditBox(this.font, fieldX1 + 1, textY, fieldW - 2, 16, (Component)Component.literal((String)"Hex")){

            public void setFocused(boolean focused) {
                boolean old = this.isFocused();
                super.setFocused(focused);
                if (old && !focused) {
                    ColorPickerScreen.this.updateTextbox();
                    CSNetwork.sendToServer(new SetColorPayload(ColorPickerScreen.this.rgb()));
                }
            }
        };
        this.textbox.setMaxLength(7);
        this.textbox.setBordered(true);
        this.textbox.setEditable(true);
        this.textbox.setValue(this.hex(this.rgb()));
        this.textbox.setResponder(this::textBoxResponder);
        this.addRenderableWidget((GuiEventListener)this.textbox);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.width, this.height, -2013265920);
        super.render(graphics, mouseX, mouseY, partial);
        int x0 = (this.width - this.width()) / 2;
        int y0 = (this.height - this.height()) / 2;
        graphics.fill(x0 - 6, y0 - 6, x0 + this.width() + 6, y0 + this.height() + 6, -267053803);
        this.border(graphics, x0 - 6, y0 - 6, x0 + this.width() + 6, y0 + this.height() + 6, -1);
        int svX = x0 + 10;
        int svY = y0 + 10;
        this.updateSV();
        if (this.svTextureId != null) {
            graphics.blit(this.svTextureId, svX, svY, 0.0f, 0.0f, 180, 180, 180, 180);
            this.border(graphics, svX, svY, svX + 180, svY + 180, -16777216);
        }
        int cursorX = svX + Math.round(this.saturation * 179.0f);
        int cursorY = svY + Math.round((1.0f - this.value) * 179.0f);
        this.drawCursor(graphics, cursorX, cursorY);
        int hueX = svX + 180 + 6;
        int hueY = svY;
        this.updateHue();
        if (this.hueTextureId != null) {
            graphics.blit(this.hueTextureId, hueX, hueY, 0.0f, 0.0f, 18, 180, 18, 180);
            this.border(graphics, hueX, hueY, hueX + 18, hueY + 180, -16777216);
        }
        int barY = hueY + Math.round(this.hue * 179.0f);
        int barX = hueX;
        this.drawSelector(graphics, barX, barY);
        int previewY = svY + 180 + 6;
        int previewH = 18;
        int previewX1 = svX;
        int previewX2 = hueX + 18;
        graphics.fill(previewX1, previewY, previewX2, previewY + previewH, 0xFF000000 | this.rgb());
        this.border(graphics, previewX1, previewY, previewX2, previewY + previewH, -16777216);
        int textY = previewY + previewH + 4;
        if (this.textbox != null) {
            int fieldX1 = svX;
            int fieldW = hueX + 18 - svX;
            this.textbox.setX(fieldX1 + 1);
            this.textbox.setY(textY);
            this.textbox.setWidth(fieldW - 2);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int svX = this.svX();
        int svY = this.svY();
        int hueX = this.hueX();
        int hueY = this.hueY();
        this.textbox.setFocused(this.textbox.isHovered());
        if (mouseX >= (double)svX && mouseX <= (double)(svX + 180) && mouseY >= (double)svY && mouseY <= (double)(svY + 180)) {
            this.isDraggingColor = true;
            this.updateSV((int)mouseX, (int)mouseY);
            this.updateTextbox();
            return true;
        }
        if (mouseX >= (double)hueX && mouseX <= (double)(hueX + 18) && mouseY >= (double)hueY && mouseY <= (double)(hueY + 180)) {
            this.isDraggingHue = true;
            this.updateHue((int)mouseY);
            this.updateTextbox();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.isDraggingColor) {
            this.updateSV((int)mouseX, (int)mouseY);
            this.isSvDirty = true;
            this.updateTextbox();
        }
        if (this.isDraggingHue) {
            this.updateHue((int)mouseY);
            this.isSvDirty = true;
            this.updateTextbox();
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean wasDragging = this.isDraggingColor || this.isDraggingHue;
        this.isDraggingColor = false;
        this.isDraggingHue = false;
        if (wasDragging) {
            CSNetwork.sendToServer(new SetColorPayload(this.rgb()));
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.textbox.isFocused()) {
            String value = this.textbox.getValue();
            this.textBoxResponder(value);
            CSNetwork.sendToServer(new SetColorPayload(this.rgb()));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void textBoxResponder(String content) {
        if (this.isUpdating) {
            return;
        }
        if (content == null) {
            return;
        }
        String text = content.trim();
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        StringBuilder filtered = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) continue;
            filtered.append(c);
        }
        StringBuilder result = new StringBuilder(filtered.toString());
        if (result.length() > 6) {
            result = new StringBuilder(result.substring(0, 6));
        }
        while (result.length() < 6) {
            result.append('F');
        }
        String hex = result.toString().toUpperCase();
        int rgb = Integer.parseInt(hex, 16) & 0xFFFFFF;
        this.rgb(rgb);
    }

    private void border(GuiGraphics graphics, int x1, int y1, int x2, int y2, int color) {
        graphics.fill(x1, y1, x2, y1 + 1, color);
        graphics.fill(x1, y2 - 1, x2, y2, color);
        graphics.fill(x1, y1, x1 + 1, y2, color);
        graphics.fill(x2 - 1, y1, x2, y2, color);
    }

    private int rgb() {
        return Mth.hsvToRgb((float)this.hue, (float)this.saturation, (float)this.value) & 0xFFFFFF;
    }

    private void rgb(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        this.value = max;
        float f = this.saturation = max == 0.0f ? 0.0f : delta / max;
        float h = delta == 0.0f ? 0.0f : (max == r ? (g - b) / delta % 6.0f : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        this.hue = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
        this.isSvDirty = true;
    }

    private String hex(int rgb) {
        return String.format("#%06X", 0xFFFFFF & rgb);
    }

    private void updateHue() {
        if (this.isHueBuilt && this.hueTexture != null && this.hueTextureId != null) {
            return;
        }
        this.hueTexture = new DynamicTexture(18, 180, true);
        NativeImage image = this.hueTexture.getPixels();
        if (image != null) {
            for (int y = 0; y < 180; ++y) {
                float hue = (float)y / 179.0f;
                int rgb = Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f) & 0xFFFFFF;
                int abgr = 0xFF000000 | (rgb & 0xFF) << 16 | rgb & 0xFF00 | rgb >> 16 & 0xFF;
                for (int x = 0; x < 18; ++x) {
                    image.setPixelRGBA(x, y, abgr);
                }
            }
            this.hueTexture.upload();
        }
        this.hueTextureId = Minecraft.getInstance().getTextureManager().register("crystalix/color_picker/hue", this.hueTexture);
        this.isHueBuilt = true;
    }

    private void updateHue(int mouseY) {
        int hueY = this.hueY();
        float h = (float)(mouseY - hueY) / 179.0f;
        float hue = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
        if (hue != this.hue) {
            this.hue = hue;
            this.isSvDirty = true;
        }
    }

    private void updateSV() {
        NativeImage image;
        if (!this.isSvDirty && this.svTexture != null && this.svTextureId != null && this.svCache == this.hue) {
            return;
        }
        if (this.svTexture == null) {
            this.svTexture = new DynamicTexture(180, 180, true);
        }
        if ((image = this.svTexture.getPixels()) != null) {
            for (int y = 0; y < 180; ++y) {
                float value = 1.0f - (float)y / 179.0f;
                for (int x = 0; x < 180; ++x) {
                    float saturation = (float)x / 179.0f;
                    int rgb = Mth.hsvToRgb((float)this.hue, (float)saturation, (float)value) & 0xFFFFFF;
                    int abgr = 0xFF000000 | (rgb & 0xFF) << 16 | rgb & 0xFF00 | rgb >> 16 & 0xFF;
                    image.setPixelRGBA(x, y, abgr);
                }
            }
            this.svTexture.upload();
        }
        if (this.svTextureId == null) {
            this.svTextureId = Minecraft.getInstance().getTextureManager().register("crystalix/color_picker/sv", this.svTexture);
        }
        this.svCache = this.hue;
        this.isSvDirty = false;
    }

    private void updateSV(int mouseX, int mouseY) {
        int svX = this.svX();
        int svY = this.svY();
        float saturation = (float)(mouseX - svX) / 179.0f;
        float value = 1.0f - (float)(mouseY - svY) / 179.0f;
        this.saturation = Mth.clamp((float)saturation, (float)0.0f, (float)1.0f);
        this.value = Mth.clamp((float)value, (float)0.0f, (float)1.0f);
    }

    private void updateTextbox() {
        if (this.textbox == null) {
            return;
        }
        this.isUpdating = true;
        try {
            int rgb = this.rgb();
            this.textbox.setValue(this.hex(rgb));
        }
        finally {
            this.isUpdating = false;
        }
    }

    private void drawCursor(GuiGraphics graphics, int x, int y) {
        int r = 4;
        this.border(graphics, x - 4, y - 4, x + 4, y + 4, -1);
        this.border(graphics, x - 4 + 1, y - 4 + 1, x + 4 - 1, y + 4 - 1, -16777216);
    }

    private void drawSelector(GuiGraphics graphics, int x, int y) {
        this.border(graphics, x - 1 - 1, y - 2 - 1, x + 18 + 1 + 1, y + 2 + 1, -1);
        this.border(graphics, x - 1, y - 2, x + 18 + 1, y + 2, -16777216);
    }
}

