/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block.entity;

import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.component.ChimesComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WindBellBE
extends BlockEntity {
    @Nullable
    private String itemBaseColor;
    @Nullable
    private String itemTagColor;
    public int chimeTicks;
    public boolean isSwinging;

    public WindBellBE(BlockPos p_155173_, BlockState p_155174_) {
        super(ChimesBlocks.WIND_BELL_BLOCK_ENTITY, p_155173_, p_155174_);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chimeTicks = 0;
            this.isSwinging = true;
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void fromItem(ItemStack p_187454_) {
        this.applyComponentsFromItemStack(p_187454_);
    }

    public ItemStack getItem() {
        ItemStack itemStack = new ItemStack(() -> ChimesBlocks.GLASSBELLSITEM);
        itemStack.applyComponents(this.collectComponents());
        return itemStack;
    }

    public void tick() {
        AABB aabb = new AABB(this.getBlockPos()).inflate(7.0, 7.0, 7.0);
        List list = this.level.getEntitiesOfClass(Phantom.class, aabb);
        if (this.level.isLoaded(this.worldPosition)) {
            if (this.isSwinging) {
                ++this.chimeTicks;
            }
            if (!list.isEmpty()) {
                for (Phantom phantom : list) {
                    if (!(phantom instanceof Phantom) || phantom.getTarget() == null) continue;
                    phantom.setTarget(null);
                }
            }
            if (this.chimeTicks >= 200) {
                this.isSwinging = false;
                this.chimeTicks = 0;
            }
        }
    }

    public void chime() {
        BlockPos blockpos = this.getBlockPos();
        if (this.isSwinging) {
            this.chimeTicks = 0;
        } else {
            this.isSwinging = true;
        }
        this.level.blockEvent(blockpos, this.getBlockState().getBlock(), 1, 0);
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider provider) {
        super.saveAdditional(p_187471_, provider);
        if (this.itemBaseColor != null) {
            p_187471_.putString("Base", this.itemBaseColor);
        }
        if (this.itemTagColor != null) {
            p_187471_.putString("Tag", this.itemTagColor);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (compoundTag.get("Base") != null) {
            this.itemBaseColor = compoundTag.getString("Base");
        }
        if (compoundTag.get("Tag") != null) {
            this.itemTagColor = compoundTag.getString("Tag");
        }
        super.loadAdditional(compoundTag, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        if (dataComponentInput.get(ChimesComponents.GLASS_BELL_BASE_COLOR) != null) {
            this.itemBaseColor = (String)dataComponentInput.get(ChimesComponents.GLASS_BELL_BASE_COLOR);
        }
        if (dataComponentInput.get(ChimesComponents.GLASS_BELL_TAG_COLOR) != null) {
            this.itemTagColor = (String)dataComponentInput.get(ChimesComponents.GLASS_BELL_TAG_COLOR);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (this.itemBaseColor != null) {
            builder.set(ChimesComponents.GLASS_BELL_BASE_COLOR, (Object)this.itemBaseColor);
        }
        if (this.itemTagColor != null) {
            builder.set(ChimesComponents.GLASS_BELL_TAG_COLOR, (Object)this.itemTagColor);
        }
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        compoundTag.remove("Base");
        compoundTag.remove("Tag");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return super.saveWithoutMetadata(provider);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ(), (double)(this.getBlockPos().getX() + 1), (double)(this.getBlockPos().getY() - 2), (double)(this.getBlockPos().getZ() + 1));
    }
}

