/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.block.WindChimeTyableBlock;
import com.nick.chimes.block.entity.WindChimeBE;
import com.nick.chimes.sound.ChimesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronWindChimeBlock
extends WindChimeTyableBlock {
    private static final VoxelShape chime1 = IronWindChimeBlock.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static final VoxelShape perhaps = IronWindChimeBlock.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape yes = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)8.0, (double)12.0);
    private static final VoxelShape yes1 = IronWindChimeBlock.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    private static final VoxelShape yes2 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)8.0, (double)6.0);
    private static final VoxelShape yes3 = IronWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0);
    private static final VoxelShape maybe = Shapes.or((VoxelShape)chime1, (VoxelShape[])new VoxelShape[]{perhaps, yes, yes1, yes2, yes3});
    private static final VoxelShape yes02 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)8.0, (double)12.0);
    private static final VoxelShape yes12 = IronWindChimeBlock.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    private static final VoxelShape yes22 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)8.0, (double)6.0);
    private static final VoxelShape yes32 = IronWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0);
    private static final VoxelShape maybe2 = Shapes.or((VoxelShape)chime1, (VoxelShape[])new VoxelShape[]{perhaps, yes02, yes12, yes22, yes32});
    private static final VoxelShape yes03 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)9.0, (double)12.0);
    private static final VoxelShape yes13 = IronWindChimeBlock.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)8.0, (double)9.0);
    private static final VoxelShape yes23 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)9.0, (double)6.0);
    private static final VoxelShape yes33 = IronWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)8.0, (double)9.0);
    private static final VoxelShape maybe3 = Shapes.or((VoxelShape)chime1, (VoxelShape[])new VoxelShape[]{perhaps, yes03, yes13, yes23, yes33});
    private static final VoxelShape yes04 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)9.0, (double)12.0);
    private static final VoxelShape yes14 = IronWindChimeBlock.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)8.0, (double)9.0);
    private static final VoxelShape yes24 = IronWindChimeBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)9.0, (double)6.0);
    private static final VoxelShape yes34 = IronWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)8.0, (double)9.0);
    private static final VoxelShape maybe4 = Shapes.or((VoxelShape)chime1, (VoxelShape[])new VoxelShape[]{perhaps, yes04, yes14, yes24, yes34});
    private static final VoxelShape yesb = IronWindChimeBlock.box((double)7.0, (double)4.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0);
    private static final VoxelShape yes1b = IronWindChimeBlock.box((double)4.0, (double)3.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0);
    private static final VoxelShape yes2b = IronWindChimeBlock.box((double)7.0, (double)6.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0);
    private static final VoxelShape yes3b = IronWindChimeBlock.box((double)10.0, (double)9.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0);
    private static final VoxelShape maybeb = Shapes.or((VoxelShape)yesb, (VoxelShape[])new VoxelShape[]{yes1b, yes2b, yes3b});
    private static final VoxelShape yes02b = IronWindChimeBlock.box((double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0);
    private static final VoxelShape yes12b = IronWindChimeBlock.box((double)4.0, (double)9.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0);
    private static final VoxelShape yes22b = IronWindChimeBlock.box((double)7.0, (double)4.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0);
    private static final VoxelShape yes32b = IronWindChimeBlock.box((double)10.0, (double)3.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0);
    private static final VoxelShape maybe2b = Shapes.or((VoxelShape)yes02b, (VoxelShape[])new VoxelShape[]{yes12b, yes22b, yes32b});
    private static final VoxelShape yes03b = IronWindChimeBlock.box((double)7.0, (double)3.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0);
    private static final VoxelShape yes13b = IronWindChimeBlock.box((double)4.0, (double)6.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0);
    private static final VoxelShape yes23b = IronWindChimeBlock.box((double)7.0, (double)9.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0);
    private static final VoxelShape yes33b = IronWindChimeBlock.box((double)10.0, (double)4.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0);
    private static final VoxelShape maybe3b = Shapes.or((VoxelShape)yes03b, (VoxelShape[])new VoxelShape[]{yes13b, yes23b, yes33b});
    private static final VoxelShape yes04b = IronWindChimeBlock.box((double)7.0, (double)9.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0);
    private static final VoxelShape yes14b = IronWindChimeBlock.box((double)4.0, (double)4.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0);
    private static final VoxelShape yes24b = IronWindChimeBlock.box((double)7.0, (double)3.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0);
    private static final VoxelShape yes34b = IronWindChimeBlock.box((double)10.0, (double)6.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0);
    private static final VoxelShape maybe4b = Shapes.or((VoxelShape)yes04b, (VoxelShape[])new VoxelShape[]{yes14b, yes24b, yes34b});

    public IronWindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean flag = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return flag ? maybe : maybeb;
            }
            case SOUTH: {
                return flag ? maybe2 : maybe2b;
            }
            case WEST: {
                return flag ? maybe3 : maybe3b;
            }
            case EAST: {
                return flag ? maybe4 : maybe4b;
            }
        }
        return chime1;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource randomSource) {
        if (level.isClientSide) {
            float posX = (float)pos.getX() + 0.5f;
            float posY = (float)pos.getY() + 0.5f;
            float posZ = (float)pos.getZ() + 0.5f;
            if (!((Boolean)stateIn.getValue((Property)ChimesStates.SILENCED)).booleanValue() && randomSource.nextFloat() < 0.015f) {
                level.playLocalSound((double)posX, (double)posY, (double)posZ, ChimesSounds.IRONCHIMING, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }

    @Override
    public void playChimeSound(Level world, BlockPos pos) {
        world.playSound(null, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), ChimesSounds.IRONCHIME, SoundSource.BLOCKS, 1.5f, 1.0f);
    }

    @Override
    public void playTieSound(Level world, BlockPos pos) {
        world.playSound(null, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), ChimesSounds.IRONTIE, SoundSource.BLOCKS, 1.5f, 1.0f);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_152198_, BlockState p_152199_) {
        return new WindChimeBE.IronBE(p_152198_, p_152199_);
    }
}

