/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.block.WindChimeTyableBlock;
import com.nick.chimes.block.entity.WindChimeBE;
import com.nick.chimes.sound.ChimesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperWindChimeBlock
extends WindChimeTyableBlock {
    private static VoxelShape chime = CopperWindChimeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private static VoxelShape chimetopper = CopperWindChimeBlock.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static VoxelShape copperpipe1A = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)2.0, (double)13.0);
    private static VoxelShape copperpipe2A = CopperWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)13.0, (double)4.0, (double)10.0);
    private static VoxelShape copperpipe3A = CopperWindChimeBlock.box((double)7.0, (double)0.0, (double)3.0, (double)10.0, (double)6.0, (double)6.0);
    private static VoxelShape copperpipe4A = CopperWindChimeBlock.box((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)8.0, (double)9.0);
    private static VoxelShape copperchimesupn = Shapes.or((VoxelShape)chimetopper, (VoxelShape[])new VoxelShape[]{copperpipe1A, copperpipe2A, copperpipe3A, copperpipe4A});
    private static VoxelShape copperpipe11A = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)6.0, (double)13.0);
    private static VoxelShape copperpipe12A = CopperWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)13.0, (double)8.0, (double)10.0);
    private static VoxelShape copperpipe13A = CopperWindChimeBlock.box((double)7.0, (double)0.0, (double)3.0, (double)10.0, (double)2.0, (double)6.0);
    private static VoxelShape copperpipe14A = CopperWindChimeBlock.box((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)9.0);
    private static VoxelShape copperchimesups = Shapes.or((VoxelShape)chimetopper, (VoxelShape[])new VoxelShape[]{copperpipe11A, copperpipe12A, copperpipe13A, copperpipe14A});
    private static VoxelShape copperpipe21A = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0, (double)13.0);
    private static VoxelShape copperpipe22A = CopperWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)13.0, (double)6.0, (double)10.0);
    private static VoxelShape copperpipe23A = CopperWindChimeBlock.box((double)7.0, (double)0.0, (double)3.0, (double)10.0, (double)8.0, (double)6.0);
    private static VoxelShape copperpipe24A = CopperWindChimeBlock.box((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)9.0);
    private static VoxelShape copperchimesupe = Shapes.or((VoxelShape)chimetopper, (VoxelShape[])new VoxelShape[]{copperpipe21A, copperpipe22A, copperpipe23A, copperpipe24A});
    private static VoxelShape copperpipe31A = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)8.0, (double)13.0);
    private static VoxelShape copperpipe32A = CopperWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)13.0, (double)2.0, (double)10.0);
    private static VoxelShape copperpipe33A = CopperWindChimeBlock.box((double)7.0, (double)0.0, (double)3.0, (double)10.0, (double)4.0, (double)6.0);
    private static VoxelShape copperpipe34A = CopperWindChimeBlock.box((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)9.0);
    private static VoxelShape copperchimesupw = Shapes.or((VoxelShape)chimetopper, (VoxelShape[])new VoxelShape[]{copperpipe31A, copperpipe32A, copperpipe33A, copperpipe34A});
    private static VoxelShape copperpipe1B = CopperWindChimeBlock.box((double)6.0, (double)-2.0, (double)10.0, (double)9.0, (double)16.0, (double)13.0);
    private static VoxelShape copperpipe2B = CopperWindChimeBlock.box((double)10.0, (double)0.0, (double)7.0, (double)13.0, (double)16.0, (double)10.0);
    private static VoxelShape copperpipe3B = CopperWindChimeBlock.box((double)7.0, (double)2.0, (double)3.0, (double)10.0, (double)16.0, (double)6.0);
    private static VoxelShape copperpipe4B = CopperWindChimeBlock.box((double)3.0, (double)4.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0);
    private static VoxelShape copperchimeslon = Shapes.or((VoxelShape)copperpipe1B, (VoxelShape[])new VoxelShape[]{copperpipe2B, copperpipe3B, copperpipe4B});
    private static VoxelShape copperpipe11B = CopperWindChimeBlock.box((double)6.0, (double)2.0, (double)10.0, (double)9.0, (double)16.0, (double)13.0);
    private static VoxelShape copperpipe12B = CopperWindChimeBlock.box((double)10.0, (double)4.0, (double)7.0, (double)13.0, (double)16.0, (double)10.0);
    private static VoxelShape copperpipe13B = CopperWindChimeBlock.box((double)7.0, (double)-2.0, (double)3.0, (double)10.0, (double)16.0, (double)6.0);
    private static VoxelShape copperpipe14B = CopperWindChimeBlock.box((double)3.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0);
    private static VoxelShape copperchimeslos = Shapes.or((VoxelShape)copperpipe11B, (VoxelShape[])new VoxelShape[]{copperpipe12B, copperpipe13B, copperpipe14B});
    private static VoxelShape copperpipe21B = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0, (double)13.0);
    private static VoxelShape copperpipe22B = CopperWindChimeBlock.box((double)10.0, (double)2.0, (double)7.0, (double)13.0, (double)16.0, (double)10.0);
    private static VoxelShape copperpipe23B = CopperWindChimeBlock.box((double)7.0, (double)4.0, (double)3.0, (double)10.0, (double)16.0, (double)6.0);
    private static VoxelShape copperpipe24B = CopperWindChimeBlock.box((double)3.0, (double)-2.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0);
    private static VoxelShape copperchimesloe = Shapes.or((VoxelShape)copperpipe21B, (VoxelShape[])new VoxelShape[]{copperpipe22B, copperpipe23B, copperpipe24B});
    private static VoxelShape copperpipe31B = CopperWindChimeBlock.box((double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)16.0, (double)13.0);
    private static VoxelShape copperpipe32B = CopperWindChimeBlock.box((double)10.0, (double)-2.0, (double)7.0, (double)13.0, (double)16.0, (double)10.0);
    private static VoxelShape copperpipe33B = CopperWindChimeBlock.box((double)7.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)6.0);
    private static VoxelShape copperpipe34B = CopperWindChimeBlock.box((double)3.0, (double)2.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0);
    private static VoxelShape copperchimeslow = Shapes.or((VoxelShape)copperpipe31B, (VoxelShape[])new VoxelShape[]{copperpipe32B, copperpipe33B, copperpipe34B});
    private static VoxelShape chimepole = CopperWindChimeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)9.0, (double)16.0, (double)9.0);
    private static VoxelShape chimecollide = Shapes.or((VoxelShape)chimetopper, (VoxelShape)chimepole);

    public CopperWindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        boolean flag = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return flag ? copperchimesupn : copperchimeslon;
            }
            case SOUTH: {
                return flag ? copperchimesups : copperchimeslos;
            }
            case EAST: {
                return flag ? copperchimesupe : copperchimesloe;
            }
            case WEST: {
                return flag ? copperchimesupw : copperchimeslow;
            }
        }
        return chime;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource randomSource) {
        if (level.isClientSide) {
            float posX = (float)pos.getX() + 0.5f;
            float posY = (float)pos.getY() + 0.5f;
            float posZ = (float)pos.getZ() + 0.5f;
            if (!((Boolean)stateIn.getValue((Property)ChimesStates.SILENCED)).booleanValue() && randomSource.nextInt(100) == 0) {
                level.playLocalSound((double)posX, (double)posY, (double)posZ, ChimesSounds.COPPERCHIMING, SoundSource.AMBIENT, 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void playChimeSound(Level world, BlockPos pos) {
        world.playSound(null, pos, ChimesSounds.COPPERCHIMING, SoundSource.BLOCKS, 2.5f, 1.0f);
    }

    @Override
    public void playTieSound(Level world, BlockPos pos) {
        world.playSound(null, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), ChimesSounds.IRONTIE, SoundSource.BLOCKS, 1.5f, 0.5f);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_152198_, BlockState p_152199_) {
        return new WindChimeBE.CopperBE(p_152198_, p_152199_);
    }
}

