/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.Placement;
import com.nick.chimes.block.CarvedBambooWindChimeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class BambooWindChimeBlock
extends CarvedBambooWindChimeBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<Placement> PLACEMENT = EnumProperty.create((String)"placement", Placement.class);

    public BambooWindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(PLACEMENT, (Comparable)((Object)Placement.NATURAL)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49751_) {
        p_49751_.add(new Property[]{FACING, HALF, ChimesStates.SILENCED, WATERLOGGED, PLACEMENT});
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean watercheck;
        boolean bl = watercheck = worldIn.getFluidState(pos.below()).getType() == Fluids.WATER;
        if (placer.isCrouching()) {
            worldIn.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue(PLACEMENT, (Comparable)((Object)Placement.NATURAL))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(PLACEMENT, (Comparable)((Object)Placement.DIRECTIONAL)), 10);
            worldIn.setBlock(pos.below(), (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(PLACEMENT, (Comparable)((Object)Placement.NATURAL))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(watercheck))).setValue(PLACEMENT, (Comparable)((Object)Placement.DIRECTIONAL)), 10);
        } else {
            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue(PLACEMENT, (Comparable)((Object)Placement.NATURAL))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 10);
            worldIn.setBlock(pos.below(), (BlockState)((BlockState)((BlockState)state.setValue(PLACEMENT, (Comparable)((Object)Placement.NATURAL))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(watercheck)), 10);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag;
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = flag = fluidstate.getType() == Fluids.WATER;
        if (blockpos.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(blockpos.below()).canBeReplaced(context)) {
            Level world = context.getLevel();
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }
}

