/*
 * Decompiled with CFR 0.152.
 */
package com.example.consolefilter;

import com.example.consolefilter.LogFilter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="consolefilter")
@EventBusSubscriber(modid="consolefilter", bus=EventBusSubscriber.Bus.GAME)
public class ConsoleFilterMod {
    public static final String MOD_ID = "consolefilter";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"consolefilter");
    public static List<String> filterKeyword = new ArrayList<String>();

    public ConsoleFilterMod() {
        LOGGER.info("ConsoleFilter Mod initialized");
        ConsoleFilterMod.loadConfig();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.getConfiguration().getRootLogger().addFilter((Filter)new LogFilter());
        context.updateLoggers();
    }

    public static void loadConfig() {
        try {
            Path configDir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path configFile = configDir.resolve("filter_config.txt");
            List<String> defaultConfig = Arrays.asList("# Add the keywords you want to filter separated by commas", "Filters = [fell from a high place, drowned]");
            List<String> defaultFilters = Arrays.asList("fell from a high place", "drowned");
            if (!Files.exists(configFile, new LinkOption[0])) {
                Files.write(configFile, defaultConfig, new OpenOption[0]);
            }
            List<String> lines = Files.readAllLines(configFile);
            boolean filterLoaded = false;
            for (String line : lines) {
                if (!(line = line.trim()).startsWith("Filters")) continue;
                int start = line.indexOf(91);
                int end = line.indexOf(93);
                if (start != -1 && end != -1 && end > start) {
                    String content = line.substring(start + 1, end);
                    String[] keywords = content.split(",");
                    filterKeyword.clear();
                    for (String keyword : keywords) {
                        filterKeyword.add(keyword.trim());
                    }
                    filterLoaded = true;
                    LOGGER.info("Filters loaded from config: {}", filterKeyword);
                    break;
                }
                LOGGER.warn("'Filters' line malformed. Resetting config...");
                break;
            }
            if (!filterLoaded) {
                Files.write(configFile, defaultConfig, new OpenOption[0]);
                filterKeyword.clear();
                filterKeyword.addAll(defaultFilters);
                LOGGER.info("Config reset. Default filters applied: {}", filterKeyword);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config file", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MOD_ID).requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"reload").executes(context -> {
            ConsoleFilterMod.loadConfig();
            LOGGER.info("ConsoleFilter config reloaded by {}", (Object)((CommandSourceStack)context.getSource()).getTextName());
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (!server.getPlayerList().isOp(player.getGameProfile())) continue;
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7a[ConsoleFilter] config reloaded."));
            }
            return 1;
        })));
    }
}

