/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ReloadResourcesPacket
extends PacketCodec<ReloadResourcesPacket> {
    public static final CustomPacketPayload.Type<ReloadResourcesPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"reload_resources"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReloadResourcesPacket> CODEC = ReloadResourcesPacket.getCodec(ReloadResourcesPacket::new);

    public ReloadResourcesPacket() {
        super(TYPE);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void actionClient(Level level, Player player) {
        long start = System.currentTimeMillis();
        Minecraft.getInstance().reloadResourcePacks();
        long end = System.currentTimeMillis();
        player.sendSystemMessage((Component)Component.literal((String)String.format("Reloaded all resources in %s ms", end - start)));
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
    }
}

