/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.fluid;

import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class NeoForgeFluidHandlerItem
implements IFluidHandlerItem {
    private final UniversalFluidItemStorage fluidStorage;

    public NeoForgeFluidHandlerItem(@NotNull UniversalFluidItemStorage fluidStorage) {
        this.fluidStorage = fluidStorage;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.fluidStorage.getContainer();
    }

    public int getTanks() {
        return this.fluidStorage.getTanks();
    }

    @NotNull
    public net.neoforged.neoforge.fluids.FluidStack getFluidInTank(int i) {
        return FluidStackHooksForge.toForge((FluidStack)this.fluidStorage.getFluidInTank(i));
    }

    public int getTankCapacity(int i) {
        return (int)this.fluidStorage.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, @NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack) {
        return this.fluidStorage.isFluidValid(i, FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack));
    }

    public int fill(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return (int)this.fluidStorage.fill(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
    }

    @NotNull
    public net.neoforged.neoforge.fluids.FluidStack drain(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return FluidStackHooksForge.toForge((FluidStack)this.fluidStorage.drain(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate()));
    }

    @NotNull
    public net.neoforged.neoforge.fluids.FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction fluidAction) {
        for (FluidStack stack : this.fluidStorage) {
            if (stack.isEmpty()) continue;
            return FluidStackHooksForge.toForge((FluidStack)this.fluidStorage.drain(stack.copyWithAmount((long)maxDrain), fluidAction.simulate()));
        }
        return net.neoforged.neoforge.fluids.FluidStack.EMPTY;
    }
}

