/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass.test;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class WiModsTestHelper
extends Enum<WiModsTestHelper> {
    private static final AtomicInteger screenshotCounter;
    private static final /* synthetic */ WiModsTestHelper[] $VALUES;

    public static WiModsTestHelper[] values() {
        return (WiModsTestHelper[])$VALUES.clone();
    }

    public static WiModsTestHelper valueOf(String name) {
        return Enum.valueOf(WiModsTestHelper.class, name);
    }

    public static void submitAndWait(Consumer<Minecraft> consumer) {
        Minecraft mc = Minecraft.getInstance();
        mc.submit(() -> consumer.accept(mc)).join();
    }

    public static <T> T submitAndGet(Function<Minecraft, T> function) {
        Minecraft mc = Minecraft.getInstance();
        return mc.submit(() -> function.apply(mc)).join();
    }

    public static void wait(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitUntil(String event, Predicate<Minecraft> condition, Duration maxDuration) {
        LocalDateTime startTime = LocalDateTime.now();
        LocalDateTime timeout = startTime.plus(maxDuration);
        System.out.println("Waiting until " + event);
        while (true) {
            if (WiModsTestHelper.submitAndGet(condition::test).booleanValue()) break;
            if (startTime.isAfter(timeout)) {
                throw new RuntimeException("Waiting until " + event + " took too long");
            }
            WiModsTestHelper.wait(Duration.ofMillis(50L));
        }
        double seconds = (double)Duration.between(startTime, LocalDateTime.now()).toMillis() / 1000.0;
        System.out.println("Waiting until " + event + " took " + seconds + "s");
    }

    public static void waitUntil(String event, Predicate<Minecraft> condition) {
        WiModsTestHelper.waitUntil(event, condition, Duration.ofSeconds(10L));
    }

    public static void waitForScreen(Class<? extends Screen> screenClass) {
        WiModsTestHelper.waitUntil("screen " + screenClass.getName() + " is open", mc -> screenClass.isInstance(mc.screen));
    }

    public static void waitForTitleScreenFade() {
        WiModsTestHelper.waitUntil("title screen fade is complete", mc -> {
            Screen patt0$temp = mc.screen;
            if (!(patt0$temp instanceof TitleScreen)) {
                return false;
            }
            TitleScreen titleScreen = (TitleScreen)patt0$temp;
            return !titleScreen.fading;
        });
    }

    public static void waitForResourceLoading() {
        WiModsTestHelper.waitUntil("loading is complete", mc -> mc.getOverlay() == null, Duration.ofMinutes(5L));
    }

    public static void waitForWorldLoad() {
        WiModsTestHelper.waitUntil("world is loaded", mc -> mc.level != null && !(mc.screen instanceof LevelLoadingScreen), Duration.ofMinutes(30L));
    }

    public static void waitForWorldTicks(int ticks) {
        long startTicks = WiModsTestHelper.submitAndGet(mc -> mc.level.getGameTime());
        WiModsTestHelper.waitUntil(ticks + " world ticks have passed", mc -> mc.level.getGameTime() >= startTicks + (long)ticks, Duration.ofMillis(ticks * 100).plusMinutes(5L));
    }

    public static void takeScreenshot(String name) {
        WiModsTestHelper.takeScreenshot(name, Duration.ofMillis(50L));
    }

    public static void takeScreenshot(String name, Duration delay) {
        WiModsTestHelper.wait(delay);
        String count = String.format("%02d", screenshotCounter.incrementAndGet());
        String filename = count + "_" + name + ".png";
        WiModsTestHelper.submitAndWait(mc -> Screenshot.grab((File)mc.gameDirectory, (String)filename, (RenderTarget)mc.getMainRenderTarget(), message -> {}));
    }

    public static Button findButton(Minecraft mc, String translationKey) {
        String message = I18n.get((String)translationKey, (Object[])new Object[0]);
        for (Renderable drawable : mc.screen.renderables) {
            Button button;
            if (!(drawable instanceof Button) || !(button = (Button)drawable).getMessage().getString().equals(message)) continue;
            return button;
        }
        throw new RuntimeException(message + " button could not be found");
    }

    public static void checkButtonPosition(Button button, int expectedX, int expectedY) {
        String buttonName = button.getMessage().getString();
        if (button.getX() != expectedX) {
            throw new RuntimeException(buttonName + " button is at the wrong X coordinate. Expected X: " + expectedX + ", actual X: " + button.getX());
        }
        if (button.getY() != expectedY) {
            throw new RuntimeException(buttonName + " button is at the wrong Y coordinate. Expected Y: " + expectedY + ", actual Y: " + button.getY());
        }
    }

    public static void clickButton(String translationKey) {
        String buttonText = I18n.get((String)translationKey, (Object[])new Object[0]);
        WiModsTestHelper.waitUntil("button saying " + buttonText + " is visible", mc -> {
            Screen screen = mc.screen;
            if (screen == null) {
                return false;
            }
            for (Renderable drawable : screen.renderables) {
                Button button;
                if (!(drawable instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)drawable;
                if (widget instanceof Button && buttonText.equals((button = (Button)widget).getMessage().getString())) {
                    button.onPress();
                    return true;
                }
                if (!(widget instanceof CycleButton)) continue;
                button = (CycleButton)widget;
                if (!buttonText.equals(button.name.getString())) continue;
                button.onPress();
                return true;
            }
            return false;
        });
    }

    public static void setTextFieldText(int index, String text) {
        WiModsTestHelper.waitUntil("text field #" + index + " is visible", mc -> {
            Screen screen = mc.screen;
            if (screen == null) {
                return false;
            }
            int i = 0;
            for (Renderable drawable : screen.renderables) {
                if (!(drawable instanceof EditBox)) continue;
                EditBox textField = (EditBox)drawable;
                if (i == index) {
                    textField.setValue(text);
                    return true;
                }
                ++i;
            }
            return false;
        });
    }

    public static void closeScreen() {
        WiModsTestHelper.submitAndWait(mc -> mc.setScreen(null));
    }

    public static void openGameMenu() {
        WiModsTestHelper.submitAndWait(mc -> mc.setScreen((Screen)new PauseScreen(true)));
    }

    public static void openInventory() {
        WiModsTestHelper.submitAndWait(mc -> mc.setScreen((Screen)new InventoryScreen((Player)mc.player)));
    }

    public static void toggleDebugHud() {
        WiModsTestHelper.submitAndWait(mc -> mc.gui.getDebugOverlay().toggleOverlay());
    }

    public static void setPerspective(CameraType perspective) {
        WiModsTestHelper.submitAndWait(mc -> mc.options.setCameraType(perspective));
    }

    public static void dismissTutorialToasts() {
        WiModsTestHelper.submitAndWait(mc -> mc.getTutorial().setStep(TutorialSteps.NONE));
    }

    public static void clearChat() {
        WiModsTestHelper.submitAndWait(mc -> mc.gui.getChat().clearMessages(true));
    }

    public static void runChatCommand(String command) {
        System.out.println("Running command: /" + command);
        WiModsTestHelper.submitAndWait(mc -> {
            ClientPacketListener netHandler = mc.getConnection();
            ParseResults results = netHandler.getCommands().parse(command, (Object)netHandler.getSuggestionsProvider());
            if (!results.getExceptions().isEmpty()) {
                StringBuilder errors = new StringBuilder("Invalid command: " + command);
                for (CommandSyntaxException e : results.getExceptions().values()) {
                    errors.append("\n").append(e.getMessage());
                }
                throw new RuntimeException(errors.toString());
            }
            netHandler.sendCommand(command);
        });
        WiModsTestHelper.waitForWorldTicks(1);
    }

    public static void assertOneItemInSlot(int slot, Item item) {
        WiModsTestHelper.submitAndWait(mc -> {
            ItemStack stack = mc.player.getInventory().getItem(slot);
            if (!stack.is(item) || stack.getCount() != 1) {
                throw new RuntimeException("Expected 1 " + item.getName(stack).getString() + " at slot " + slot + ", found " + stack.getCount() + " " + stack.getItem().getName(stack).getString() + " instead");
            }
        });
    }

    public static void assertNoItemInSlot(int slot) {
        WiModsTestHelper.submitAndWait(mc -> {
            ItemStack stack = mc.player.getInventory().getItem(slot);
            if (!stack.isEmpty()) {
                throw new RuntimeException("Expected no item in slot " + slot + ", found " + stack.getCount() + " " + stack.getItem().getName(stack).getString() + " instead");
            }
        });
    }

    private static /* synthetic */ WiModsTestHelper[] $values() {
        return new WiModsTestHelper[0];
    }

    static {
        $VALUES = WiModsTestHelper.$values();
        screenshotCounter = new AtomicInteger(0);
    }
}

