/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass.mixin;

import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.wurstclient.glass.MoGlass;
import net.wurstclient.glass.StainedGlassSlabBlock;
import net.wurstclient.glass.StainedGlassStairsBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={StainedGlassBlock.class})
public abstract class StainedGlassBlockMixin
extends TransparentBlock
implements BeaconBeamBlock {
    @Shadow
    @Final
    private DyeColor color;

    private StainedGlassBlockMixin(MoGlass moGlass, BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        Block blockFrom = stateFrom.getBlock();
        if (blockFrom instanceof StainedGlassSlabBlock && ((StainedGlassSlabBlock)blockFrom).getColor() == this.color && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (blockFrom instanceof StainedGlassStairsBlock && ((StainedGlassStairsBlock)blockFrom).getColor() == this.color && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType typeFrom = (SlabType)stateFrom.getValue((Property)SlabBlock.TYPE);
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        if (direction == Direction.UP && typeFrom != SlabType.TOP) {
            return true;
        }
        return direction == Direction.DOWN && typeFrom != SlabType.BOTTOM;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half halfFrom = (Half)stateFrom.getValue((Property)StairBlock.HALF);
        Direction facingFrom = (Direction)stateFrom.getValue((Property)StairBlock.FACING);
        StairsShape shapeFrom = (StairsShape)stateFrom.getValue((Property)StairBlock.SHAPE);
        if (direction == Direction.UP && halfFrom == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && halfFrom == Half.TOP) {
            return true;
        }
        if (facingFrom == direction.getOpposite() && shapeFrom != StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
            return true;
        }
        if (facingFrom.getCounterClockWise() == direction && shapeFrom == StairsShape.INNER_RIGHT) {
            return true;
        }
        return facingFrom.getClockWise() == direction && shapeFrom == StairsShape.INNER_LEFT;
    }
}

