/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wurstclient.glass.StainedGlassStairsBlock;

public final class StainedGlassSlabBlock
extends SlabBlock
implements BeaconBeamBlock {
    private final DyeColor color;

    public StainedGlassSlabBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        Block blockFrom = stateFrom.getBlock();
        if (blockFrom instanceof StainedGlassBlock && ((StainedGlassBlock)blockFrom).getColor() == this.color) {
            return true;
        }
        if (blockFrom == this && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (blockFrom instanceof StainedGlassStairsBlock && ((StainedGlassStairsBlock)blockFrom).getColor() == this.color && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.getValue((Property)SlabBlock.TYPE);
        SlabType typeFrom = (SlabType)stateFrom.getValue((Property)SlabBlock.TYPE);
        switch (direction) {
            case UP: {
                if (typeFrom == SlabType.TOP || type == SlabType.BOTTOM) break;
                return true;
            }
            case DOWN: {
                if (typeFrom == SlabType.BOTTOM || type == SlabType.TOP) break;
                return true;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                if (type != typeFrom && typeFrom != SlabType.DOUBLE) break;
                return true;
            }
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.getValue((Property)SlabBlock.TYPE);
        Half halfFrom = (Half)stateFrom.getValue((Property)StairBlock.HALF);
        Direction facingFrom = (Direction)stateFrom.getValue((Property)StairBlock.FACING);
        if (direction == Direction.UP && halfFrom == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && halfFrom == Half.TOP) {
            return true;
        }
        if (facingFrom == direction.getOpposite()) {
            return true;
        }
        if (direction.get2DDataValue() != -1) {
            if (type == SlabType.BOTTOM && halfFrom == Half.BOTTOM) {
                return true;
            }
            if (type == SlabType.TOP && halfFrom == Half.TOP) {
                return true;
            }
        }
        return false;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public DyeColor getColor() {
        return this.color;
    }
}

