/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.wurstclient.glass.GlassSlabBlock;
import net.wurstclient.glass.GlassStairsBlock;
import net.wurstclient.glass.StainedGlassSlabBlock;
import net.wurstclient.glass.StainedGlassStairsBlock;
import net.wurstclient.glass.TintedGlassSlabBlock;
import net.wurstclient.glass.TintedGlassStairsBlock;

public final class MoGlassBlocks
extends Enum<MoGlassBlocks> {
    public static final DeferredRegister.Blocks BLOCKS;
    public static final DeferredRegister.Items ITEMS;
    public static final DeferredBlock<Block> GLASS_SLAB;
    public static final DeferredBlock<Block> GLASS_STAIRS;
    public static final DeferredBlock<Block> TINTED_GLASS_SLAB;
    public static final DeferredBlock<Block> TINTED_GLASS_STAIRS;
    public static final List<DeferredBlock<StainedGlassSlabBlock>> STAINED_GLASS_SLABS;
    public static final List<DeferredBlock<StainedGlassStairsBlock>> STAINED_GLASS_STAIRS;
    private static final /* synthetic */ MoGlassBlocks[] $VALUES;

    public static MoGlassBlocks[] values() {
        return (MoGlassBlocks[])$VALUES.clone();
    }

    public static MoGlassBlocks valueOf(String name) {
        return Enum.valueOf(MoGlassBlocks.class, name);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String idPath, Supplier<T> block) {
        System.out.println("Registering block & item for mo_glass:" + idPath);
        DeferredBlock result = BLOCKS.register(idPath, block);
        ITEMS.register(idPath, () -> new BlockItem((Block)result.get(), new Item.Properties()));
        return result;
    }

    private static DeferredBlock<StainedGlassSlabBlock> createStainedGlassSlab(DyeColor color) {
        return MoGlassBlocks.registerBlock(String.valueOf(color) + "_stained_glass_slab", () -> new StainedGlassSlabBlock(color, BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
    }

    private static DeferredBlock<StainedGlassStairsBlock> createStainedGlassStairs(DyeColor color) {
        return MoGlassBlocks.registerBlock(String.valueOf(color) + "_stained_glass_stairs", () -> new StainedGlassStairsBlock(color, BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
    }

    private static Boolean never(BlockState blockState, BlockGetter blockView, BlockPos blockPos, EntityType<?> entityType) {
        return false;
    }

    private static boolean never(BlockState blockState, BlockGetter blockView, BlockPos blockPos) {
        return false;
    }

    private static /* synthetic */ MoGlassBlocks[] $values() {
        return new MoGlassBlocks[0];
    }

    static {
        $VALUES = MoGlassBlocks.$values();
        BLOCKS = DeferredRegister.createBlocks((String)"mo_glass");
        ITEMS = DeferredRegister.createItems((String)"mo_glass");
        GLASS_SLAB = MoGlassBlocks.registerBlock("glass_slab", () -> new GlassSlabBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
        GLASS_STAIRS = MoGlassBlocks.registerBlock("glass_stairs", () -> new GlassStairsBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
        TINTED_GLASS_SLAB = MoGlassBlocks.registerBlock("tinted_glass_slab", () -> new TintedGlassSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).mapColor(MapColor.COLOR_GRAY).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
        TINTED_GLASS_STAIRS = MoGlassBlocks.registerBlock("tinted_glass_stairs", () -> new TintedGlassStairsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).mapColor(MapColor.COLOR_GRAY).noOcclusion().isValidSpawn(MoGlassBlocks::never).isRedstoneConductor(MoGlassBlocks::never).isSuffocating(MoGlassBlocks::never).isViewBlocking(MoGlassBlocks::never)));
        STAINED_GLASS_SLABS = Arrays.stream(DyeColor.values()).map(color -> MoGlassBlocks.createStainedGlassSlab(color)).toList();
        STAINED_GLASS_STAIRS = Arrays.stream(DyeColor.values()).map(color -> MoGlassBlocks.createStainedGlassStairs(color)).toList();
    }
}

