/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common.items;

import it.hurts.octostudios.cardiac.common.entities.ThrownLifeBottle;
import it.hurts.octostudios.cardiac.common.init.EntityRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class LifeBottleItem
extends Item
implements ProjectileItem {
    public LifeBottleItem() {
        super(new Item.Properties().arch$tab(CreativeModeTabs.INGREDIENTS).rarity(Rarity.UNCOMMON));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownLifeBottle bottle = new ThrownLifeBottle((EntityType<? extends ThrownLifeBottle>)((EntityType)EntityRegistry.THROWN_LIFE_BOTTLE.get()), level);
            bottle.setItem(stack);
            bottle.setOwner((Entity)player);
            bottle.setPos(player.getEyePosition());
            bottle.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.7f, 1.0f);
            level.addFreshEntity((Entity)bottle);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        ThrownLifeBottle thrownLifeBottle = new ThrownLifeBottle((EntityType<? extends ThrownLifeBottle>)((EntityType)EntityRegistry.THROWN_LIFE_BOTTLE.get()), level);
        thrownLifeBottle.setPos(position.x(), position.y(), position.z());
        thrownLifeBottle.setItem(itemStack);
        return thrownLifeBottle;
    }
}

